<?php

namespace FASTRANSPLUGIN\Inc;


use FASTRANSPLUGIN\Inc\Abstracts\Taxonomy;


class Taxonomies extends Taxonomy {


	public static function init() {

		$labels = array(
			'name'              => _x( 'Project Category', 'wpfastrans' ),
			'singular_name'     => _x( 'Project Category', 'wpfastrans' ),
			'search_items'      => __( 'Search Category', 'wpfastrans' ),
			'all_items'         => __( 'All Categories', 'wpfastrans' ),
			'parent_item'       => __( 'Parent Category', 'wpfastrans' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpfastrans' ),
			'edit_item'         => __( 'Edit Category', 'wpfastrans' ),
			'update_item'       => __( 'Update Category', 'wpfastrans' ),
			'add_new_item'      => __( 'Add New Category', 'wpfastrans' ),
			'new_item_name'     => __( 'New Category Name', 'wpfastrans' ),
			'menu_name'         => __( 'Project Category', 'wpfastrans' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'project_cat' ),
		);

		register_taxonomy( 'project_cat', 'project', $args );
		
		//Services Taxonomy Start
		$labels = array(
			'name'              => _x( 'Service Category', 'wpfastrans' ),
			'singular_name'     => _x( 'Service Category', 'wpfastrans' ),
			'search_items'      => __( 'Search Category', 'wpfastrans' ),
			'all_items'         => __( 'All Categories', 'wpfastrans' ),
			'parent_item'       => __( 'Parent Category', 'wpfastrans' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpfastrans' ),
			'edit_item'         => __( 'Edit Category', 'wpfastrans' ),
			'update_item'       => __( 'Update Category', 'wpfastrans' ),
			'add_new_item'      => __( 'Add New Category', 'wpfastrans' ),
			'new_item_name'     => __( 'New Category Name', 'wpfastrans' ),
			'menu_name'         => __( 'Service Category', 'wpfastrans' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'service_cat' ),
		);


		register_taxonomy( 'service_cat', 'service', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpfastrans' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpfastrans' ),
			'search_items'      => __( 'Search Category', 'wpfastrans' ),
			'all_items'         => __( 'All Categories', 'wpfastrans' ),
			'parent_item'       => __( 'Parent Category', 'wpfastrans' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpfastrans' ),
			'edit_item'         => __( 'Edit Category', 'wpfastrans' ),
			'update_item'       => __( 'Update Category', 'wpfastrans' ),
			'add_new_item'      => __( 'Add New Category', 'wpfastrans' ),
			'new_item_name'     => __( 'New Category Name', 'wpfastrans' ),
			'menu_name'         => __( 'Testimonials Category', 'wpfastrans' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);


		register_taxonomy( 'testimonials_cat', 'testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpfastrans' ),
			'singular_name'     => _x( 'Team Category', 'wpfastrans' ),
			'search_items'      => __( 'Search Category', 'wpfastrans' ),
			'all_items'         => __( 'All Categories', 'wpfastrans' ),
			'parent_item'       => __( 'Parent Category', 'wpfastrans' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpfastrans' ),
			'edit_item'         => __( 'Edit Category', 'wpfastrans' ),
			'update_item'       => __( 'Update Category', 'wpfastrans' ),
			'add_new_item'      => __( 'Add New Category', 'wpfastrans' ),
			'new_item_name'     => __( 'New Category Name', 'wpfastrans' ),
			'menu_name'         => __( 'Team Category', 'wpfastrans' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);


		register_taxonomy( 'team_cat', 'team', $args );
		
		//Faqs Taxonomy Start
		$labels = array(
			'name'              => _x( 'Faqs Category', 'wpfastrans' ),
			'singular_name'     => _x( 'Faqs Category', 'wpfastrans' ),
			'search_items'      => __( 'Search Category', 'wpfastrans' ),
			'all_items'         => __( 'All Categories', 'wpfastrans' ),
			'parent_item'       => __( 'Parent Category', 'wpfastrans' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpfastrans' ),
			'edit_item'         => __( 'Edit Category', 'wpfastrans' ),
			'update_item'       => __( 'Update Category', 'wpfastrans' ),
			'add_new_item'      => __( 'Add New Category', 'wpfastrans' ),
			'new_item_name'     => __( 'New Category Name', 'wpfastrans' ),
			'menu_name'         => __( 'Faqs Category', 'wpfastrans' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'faqs_cat' ),
		);


		register_taxonomy( 'faqs_cat', 'faqs', $args );
		
		
	}
	
}
