<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Why_Choose_Us_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_why_choose_us_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Why Choose Us V2', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'why_choose_us_v2',
				[
					'label' => esc_html__( 'Why Choose Us V2', 'fastrans' ),
				]
		);
		$this->add_control(
			'bg_image',
			[
			  'label' => __( 'Feature Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
        	'services', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Fast Transportion Service', 'fastrans')],
						['block_title' => esc_html__('Safety and Reliability', 'fastrans')],
						['block_title' => esc_html__('Shipping Worldwide', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Enter The icons', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options'  => get_fontawesome_icons(),
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'fastrans')
						],
						[
							'name' => 'block_text',
							'label' => esc_html__('Description', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('Enter Description Here', 'fastrans')
						],
					],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of why choose section
	============================================= -->
	<section id="ft-why-choose" class="ft-why-choose-section position-relative" <?php if($settings['bg_image']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>"<?php } ?>>
		<div class="container">
			<div class="ft-why-choose-content">
				<div class="row justify-content-end">
					<div class="col-lg-7">
						<div class="ft-why-choose-text-area">
							<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                            <div class="ft-section-title headline pera-content wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
								<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    			<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
                            </div>
                            <?php } ?>
							<div class="ft-why-choose-feature-wrapper">
								<?php foreach($settings['services'] as $key => $item): ?>
                                <div class="ft-why-choose-feature-item d-flex align-items-center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
									<div class="ft-why-choose-feature-icon d-flex align-items-center justify-content-center position-relative">
										<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
									</div>
									<div class="ft-why-choose-feature-text headline pera-content">
										<h3><?php echo wp_kses($item['block_title'], true);?></h3>
										<p><?php echo wp_kses($item['block_text'], true);?></p>
									</div>
								</div>
                                <?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End of of why choose section
	============================================= -->
    
    <?php 
	
	}

}