<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Why_Choose_Us extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_why_choose_us';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Why Choose Us', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'why_choose_us',
				[
					'label' => esc_html__( 'Why Choose Us', 'fastrans' ),
				]
		);
		$this->add_control(
			'bg_image',
			[
			  'label' => __( 'BG Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'blue_sonic_image',
			[
			  'label' => __( 'Blue Sonic Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'show_list',
			[
				'label'       => __( 'Enable/Disable Feature List', 'fastrans' ),
				'type'        => Controls_Manager::SWITCHER,
				'placeholder' => __( 'Enable/Disable Feature List', 'fastrans' ),
				'default' => false,
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'fastrans' ),
				'required' => array( 'show_list', '=', true ),
			]
		);
		$this->add_control(
        	'funfact', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Our Mission', 'fastrans')],
						['block_title' => esc_html__('Our Vision', 'fastrans')],
						['block_title' => esc_html__('Our Value', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'fastrans')
						],
						[
							'name' => 'img',
							'label' => __( 'Feature Image', 'fastrans' ),
						    'type' => Controls_Manager::MEDIA,
						    'default' => ['url' => Utils::get_placeholder_image_src(),],
						],
						[
							'name' => 'block_text',
							'label' => esc_html__('Text', 'fastrans'),
							'type' => Controls_Manager::TEXTAREA,
							'label_block' => true,
						],
						[
							'name' => 'block_des',
							'label' => esc_html__('Description', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						
					],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'contact_form_url',
			[
 				'label'       => __( 'Contact Form 7 Url', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Url', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_description',
			[
				'label'       => __( 'Form Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Description', 'fastrans' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'why_choose_section_style',
			[
				'label' => esc_html__( 'Why Choose Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_heading_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_heading_clr',
			[
				'label'     => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-content-2 .ft-section-title-3 span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_heading_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-why-choose-content-2 .ft-section-title-3 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'_heading_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'heading_clr',
			[
				'label'     => esc_html__( 'Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-content-2 .ft-section-title-3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'heading_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-why-choose-content-2 .ft-section-title-3 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'why_choose_style',
			[
				'label' => esc_html__( 'Why Choose Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'_wh_list_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'List Item Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_clr',
			[
				'label'     => esc_html__( 'List Item Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-list-wrapper li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'list_icon_clr',
			[
				'label'     => esc_html__( 'List Item Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-list-wrapper li:before' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'list_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-why-choose-list-wrapper li',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of why choose us section
	============================================= -->
	<section id="ft-why-choose-2" class="ft-why-choose-section-2 position-relative">
		<?php if($settings['bg_image']['id']){ ?><span class="why-choose-bg-2"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span><?php } ?>
		<?php if($settings['blue_sonic_image']['id']){ ?><span class="why-choose-img-2 position-absolute"><img src="<?php echo esc_url(wp_get_attachment_url($settings['blue_sonic_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span><?php } ?>
		<div class="container">
			<div class="ft-why-choose-content-2">
				<div class="row">
					<div class="col-lg-6">
						<div class="ft-why-choose-text-2">
							<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                            <div class="ft-section-title-3 headline">
								<?php if( $settings['subtitle'] ){ ?><span class="text-uppercase"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    			<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
							</div>
                            <?php } ?>
                            <?php if( $settings[ 'show_list' ] ):?>
								
								<?php $features_list = $settings['features_list'];
                                    if(!empty($features_list)){
                                    $features_list = explode("\n", ($features_list)); 
                                ?>
                                <div class="ft-why-choose-list-wrapper ul-li-block">
                                    <ul>
                                        <?php foreach($features_list as $features): ?>
                                        <li><?php echo wp_kses($features, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <?php } ?>
                                
                            <?php else:?>
                            	
                                <!-- Opportunity Info Tabs -->
                                <div class="opportunity-info-tabs">
                                    <!-- Opportunity Tabs -->
                                    <div class="opportunity-tabs tabs-box">
                                        
                                        <!-- Tab Btns -->
                                        <ul class="tab-btns tab-buttons clearfix">
                                            <?php foreach($settings['funfact'] as $key => $item): ?>
                                            <li data-tab="#prod-mission<?php echo esc_attr( $key );?>" class="tab-btn <?php if( $key == 1 ) echo 'active-btn';?>"><?php echo wp_kses($item['block_title'], true);?></li>
                                            <?php endforeach;?>
                                        </ul>
                                        
                                        <!-- Tabs Container -->
                                        <div class="tabs-content">
                                            
                                            <!-- Tab / Active Tab -->
                                            <?php foreach($settings['funfact'] as $key => $item): ?>
                                            <div class="tab <?php if( $key == 1 ) echo 'active-tab';?>" id="prod-mission<?php echo esc_attr( $key );?>">
                                                <div class="content">
                                                    <div class="image">
                                                        <img src="<?php echo esc_url(wp_get_attachment_url($item['img']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>" />
                                                    </div>
                                                    <p><?php echo wp_kses($item['block_text'], true);?></p>
                                                </div>
                                                <p><?php echo wp_kses($item['block_des'], true);?></p>
                                            </div>
                                            <?php endforeach;?>
                                            
                                        </div>
                                    </div>
                                </div>
                                
                            <?php endif;?>
						</div>
					</div>
					<?php if($settings['contact_form_url'] || $settings['form_description']){ ?>
                    <div class="col-lg-6">
						<div class="ft-why-choose-form-wrapper">
							<div class="ft-why-choose-form pera-content">
								<?php echo do_shortcode($settings['contact_form_url']); ?>
								<?php if($settings['form_description']){ ?><p><?php echo wp_kses($settings['form_description'], true); ?></p><?php } ?>
							</div>
						</div>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
	</section>
	<!-- End of why choose us section
	============================================= -->
    
    <?php 
	
	}

}