<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Welcome_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'welcome_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Welcome V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'welcome_section',
				[
					'label' => esc_html__( 'Welcome Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'shape',
            [
                'label' => esc_html__( 'Choose Shape Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'year_title',
            [
                'label' => esc_html__( 'Year Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '40 Years', 'fastrans' ),
            ]
        );
        $this->add_control(
            'year_info',
            [
                'label' => esc_html__( 'Year Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Working Exprience', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'section_tsc',
            [
                'label' => __( 'Welcome Info', 'appilo' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Welcome Transportation Company', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Providing Full Rang of Transportation Worldwide', 'fastrans' ),
            ]
        );
        $this->add_control(
            'info',
            [
                'label' => esc_html__( 'Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution .', 'fastrans' ),
            ]
        );
        $this->add_control(
            'featured_item',
            [
                'label' => esc_html__( 'Featured Items', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( '
                                <ul class="list">
									<li>It is a long established fact that a reader</li>
									<li>Many desktop publishing packages</li>
									<li>Sometimes by accident, sometimes</li>
								</ul>', 'fastrans' ),
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Explore More', 'fastrans' ),
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
        $this->end_controls_section();

		$this->start_controls_section(
			'Left_box_style',
			[
				'label' => esc_html__( 'Left Box Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .welcome-section .image-column .year-box .box-inner .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'year_text_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .welcome-section .image-column .year-box .box-inner strong' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'year_title_typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .welcome-section .image-column .year-box .box-inner strong',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Year_info_color',
			[
				'label'     => esc_html__( 'Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .welcome-section .image-column .year-box .box-inner' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Year_info_typography',
				'label'          => esc_html__( 'Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .welcome-section .image-column .year-box .box-inner',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
            'border_right_color',
            [
                'label'     => esc_html__( 'Border Right Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .welcome-section .image-column .year-box' => 'border-right-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'image_border_left_color',
            [
                'label'     => esc_html__( 'Image Border Left Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .welcome-section .image-column .image:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'welcome_info_right',
            [
                'label' => __( 'Content Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title .title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title h2',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'info_color',
            [
                'label'     => esc_html__( 'Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'info_typography',
                'label'          => esc_html__( 'Info Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'featured_color',
            [
                'label'     => esc_html__( 'Featured Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .welcome-section .content-column .list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'featured_typography',
                'label'          => esc_html__( 'Featured Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .welcome-section .content-column .list li',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'featured_circle_color',
            [
                'label'     => esc_html__( 'Featured Circle Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .welcome-section .content-column .list li:before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_btn_style',
            [
                'label' => __( 'Button Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'btn_text_color',
            [
                'label'     => esc_html__( 'Button Text Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .btn-style-three .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_bg',
            [
                'label'     => esc_html__( 'Button Icon BG', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_style',
            [
                'label' => esc_html__( 'Button Hover Style', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_hover_text_color',
            [
                'label'     => esc_html__( 'Button Hover Text Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_bg_color',
            [
                'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Welcome Section -->
        <div class="welcome-section">
            <div class="pattern-layer" style="background-image:url(<?php echo $settings['shape']['url']; ?>)"></div>
            <div class="auto-container">
                <div class="inner-container">
                    <div class="row clearfix">

                        <!-- Image Column -->
                        <div class="image-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <div class="image">
                                    <img src="<?php echo $settings['image']['url']; ?>" alt="" />
                                    <div class="year-box">
                                        <div class="box-inner">
                                            <span class="icon">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </span>
                                            <strong><?php echo $settings['year_title']; ?></strong>
                                            <?php echo $settings['year_info']; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Content Column -->
                        <div class="content-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <div class="sec-title">
                                    <div class="title"><?php echo $settings['sub_title'];?></div>
                                    <h2><?php echo $settings['title'];?></h2>
                                    <div class="text"><?php echo $settings['info'];?></div>
                                </div>
                                <?php echo $settings['featured_item'];?>
                                <div class="button-box">
                                    <a href="<?php echo $settings['button_link']['url']; ?>" class="theme-btn btn-style-three"><?php echo $settings['button_text'];?> <span class="icon fas fa-angle-double-right"></span></a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Welcome Section -->

    <?php 
	
	}

}