<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Project_Carousel extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_project_car';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V6', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_projects_v5',
			[
				'label' => esc_html__( 'Our Projects V5', 'fastrans' ),
			]
		);
        $this->add_control(
            'sub_heading', [
                'label'       => esc_html__( 'Sub heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading', [
                'label'       => esc_html__( 'heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'portfolio_id', [
                'label'       => esc_html__( 'Select portfolio', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => $this->select_param_posts(),
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );
        

        $repeater->add_control(
            'project_img',
            [
                'label' => esc_html__( 'portfolio Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'project_excerpt', [
                'label'       => esc_html__( 'Project Short Description', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'project_btn', [
                'label'       => esc_html__( 'Project Button Label', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'portfolio_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'projects_style',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Sub-Heading-Color',
			[
				'label' => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two.style-two .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Sub-Heading-Typography',
				'label' => esc_html__( 'Sub Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two.style-two .title',
			]
		);
		$this->add_control(
			'Heading-Color',
			[
				'label' => esc_html__( 'Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Heading-Typography',
				'label' => esc_html__( 'Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two h2',
			]
		);
		$this->add_control(
			'--Project-Style--',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Project-Title-Color',
			[
				'label' => esc_html__( 'Project Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .content-box h4 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Project-Title-Typography',
				'label' => esc_html__( 'Project Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .portfolio-block .inner-box .content-box h4 a',
			]
		);
		$this->add_control(
			'Title-Bottom-Border-Color',
			[
				'label' => esc_html__( 'Title Bottom Border Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .content-box h4:before' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Project-Description-Color',
			[
				'label' => esc_html__( 'Project Description Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .content-box .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Project-Description-Typography',
				'label' => esc_html__( 'Project Description Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .portfolio-block .inner-box .content-box .text',
			]
		);
		$this->add_control(
			'--Project-Button-Style--',
			[
				'label' => esc_html__( 'Project Button Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Project-Button-Color',
			[
				'label' => esc_html__( 'Project Button Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .read-more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Project-Button-Typography',
				'label' => esc_html__( 'Project Button Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .portfolio-block .inner-box .read-more',
			]
		);
		$this->add_control(
			'Project-Button-Icon-Color',
			[
				'label' => esc_html__( 'Project Button Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .read-more:before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Project-Button-Hover-Color',
			[
				'label' => esc_html__( 'Project Button Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-block .inner-box .read-more:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'Project-Nav_style_1',
			[
				'label' => __( 'Project Nav Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcnt_nav');
		$this->start_controls_tab(
			'tab_controls_normal_nav',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Project-Nav-Color',
			[
				'label' => esc_html__( 'Project Nav Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-section .owl-nav button.owl-prev, .portfolio-section .owl-nav button.owl-next' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Project-Nav-Border-Color',
			[
				'label' => esc_html__( 'Project Nav Border Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-section .owl-nav button.owl-prev' => 'border-color: {{VALUE}} !important',
					'{{WRAPPER}} .portfolio-section .owl-nav button.owl-next' => 'border-color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover_nav',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Project-Nav-Hover-Color',
			[
				'label' => esc_html__( 'Project Nav Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-section .owl-nav .owl-prev:hover, .portfolio-section .owl-nav .owl-next:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Project-Nav-Hover-Border-Color',
			[
				'label' => esc_html__( 'Project Nav Hover Border Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-section .owl-nav .owl-prev:hover' => 'border-color: {{VALUE}} !important',
					'{{WRAPPER}} .portfolio-section .owl-nav .owl-next:hover' => 'border-color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'Project-Nav-Hover-Background-Color',
			[
				'label' => esc_html__( 'Project Nav Hover Background Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio-section .owl-nav .owl-prev:hover, .portfolio-section .owl-nav .owl-next:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$sub_heading = $settings['sub_heading'];
		$heading     = $settings['heading'];
		$portfolio_boxes = $settings['portfolio_boxes'];
        
        ?>

        

        <!-- Portfolio Section -->
		<section class="portfolio-section">
			<div class="auto-container">
				<div class="sec-title-two style-two">
					<div class="title"><?php echo esc_html($sub_heading);?></div>
					<h2><?php echo esc_html($heading);?></h2>
				</div>
				<div class="project-carousel-two owl-carousel owl-theme">
				
                <?php $shape = 0; foreach($portfolio_boxes as $index => $box): $shape++;?>
                <?php  if( $box['portfolio_id'] ) : ?>
					<!-- Portfolio Block -->
					<div class="portfolio-block">
						<div class="inner-box">
							<div class="image">
								<img src="<?php echo esc_url($box['project_img']['url']);?>" alt="" />
								<div class="number"><?php echo esc_attr($shape);?></div>
							</div>
							<div class="content-box">
								<h4><a href="<?php echo esc_url(get_post_meta( $box['portfolio_id'], 'project_url', true ));?>"><?php echo get_the_title($box['portfolio_id']);?></a></h4>
								<div class="text"><?php echo esc_html($box['project_excerpt']);?></div>
								<a href="<?php echo esc_url(get_post_meta( $box['portfolio_id'], 'project_url', true ));?>" class="read-more theme-btn"><?php echo esc_html($box['project_btn']);?></a>
							</div>
						</div>
					</div>
					<?php endif; endforeach;?>
				</div>
			</div>
		</section>
		<!-- End Portfolio Section -->
        <?php 
	}
    protected function select_param_posts() {
        $args = wp_parse_args( [
            'post_type'   => 'project',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ] );
    
        $query_query = get_posts( $args );
    
        $posts = [];
        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }
    
        return $posts;
    }
}