<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Post_Grid extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_transport_post_grid';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Latest News V5', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'latest_news_v4',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		
		
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
        $this->add_control(
            'skip_post_count',
            [
                'label'   => __( 'Skip Post Count', 'fastrans' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 0,
            ]
        );
        $this->add_control(
            'date_show',
            [
                'label'          => esc_html__( 'Date Enable?', 'exodus-extension' ),
                'type'           => \Elementor\Controls_Manager::SWITCHER,
                'label_on'       => esc_html__( 'Show', 'exodus-extension' ),
                'label_off'      => esc_html__( 'Hide', 'exodus-extension' ),
                'return_value'   => 'yes',
                'default'        => 'yes',
                'style_transfer' => true,
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_stylw',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
	    $this->add_control(
		    'blog_category_style',
		    [
			    'type'      => Controls_Manager::HEADING,
			    'label'     => esc_html__( 'Blog Category Style', 'fastrans' ),
			    'separator' => 'before',
		    ]
	    );
	    $this->add_control(
		    'blog_Category-_clr',
		    [
			    'label'     => esc_html__( 'Category Color', 'fastrans' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .news-block-four .inner-box .overlay-box .title' => 'color: {{VALUE}}',
			    ],
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name'           => 'Category-__typography',
			    'label'          => esc_html__( 'Category Typography', 'fastrans' ),
			    'selector'       => '{{WRAPPER}} .news-block-four .inner-box .overlay-box .title',
		    ]
	    );
	    $this->add_control(
		    'blog_Category_BG_clr',
		    [
			    'label'     => esc_html__( 'Category BG Color', 'fastrans' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .news-block-four .inner-box .overlay-box .title' => 'background: {{VALUE}}',
			    ],
		    ]
	    );
		$this->add_control(
			'blog_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block-four .inner-box .overlay-box h3 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .news-block-four .inner-box .overlay-box h3 a',
			]
		);
	    $this->add_control(
		    'blog_title_Hover-clr',
		    [
			    'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .news-block-four .inner-box .overlay-box h3 a:hover' => 'color: {{VALUE}}',
			    ],
		    ]
	    );
		$this->add_control(
			'blog_Meta',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Meta Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_Meta_clr',
			[
				'label'     => esc_html__( 'Meta Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block-four .inner-box .post-meta li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Meta__typography',
				'label'          => esc_html__( 'Meta Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .news-block-four .inner-box .post-meta li',
			]
		);
	    $this->add_control(
		    'blog_Meta_Icon-clr',
		    [
			    'label'     => esc_html__( 'Meta Icon Color', 'fastrans' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .news-block-four .inner-box .post-meta li .icon' => 'color: {{VALUE}}',
			    ],
		    ]
	    );
	    $this->add_control(
		    'blog_admin_icon_bg-clr',
		    [
			    'label'     => esc_html__( 'Admin Icon BG Color', 'fastrans' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .news-block-four .inner-box .post-meta li:first-child .icon' => 'background: {{VALUE}}',
			    ],
		    ]
	    );
		$this->add_control(
			'blog_img_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Image Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .news-block-four .inner-box .image .main img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
            'ignore_sticky_posts' => 1,
			'paged'          => $paged
		);
        $args['offset'] = $settings['skip_post_count'];
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>
        <?php while ( $query->have_posts() ) : $query->the_post(); 
            $categories = get_the_category();
        ?>
        <!-- News Block Four -->
        <div class="news-block-four masonry-item">
            <div class="inner-box">
                <div class="image">
                    <div class="gradient-layer"></div>
                    <div class="main">
                        <?php the_post_thumbnail('full'); ?>
                    </div>
                    <div class="overlay-box">
                        <div class="title"><?php if ( ! empty( $categories ) ) {
                                        echo '' . esc_html( $categories[0]->name ) . '';
                                    }?></div>
                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                        <ul class="post-meta">
                            <li><span class="icon"><img src="<?php echo get_template_directory_uri()?>/assets/images/icons/news-icon.png" alt="" /></span><?php the_author();?></li>
                            <?php if(true == $settings['date_show']):?>
                            <li><span class="icon fa fa-calendar"></span><?php echo esc_attr(get_the_date()); ?></li>
                            <?php endif;?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <?php endwhile; ?>    
		<?php }
		wp_reset_postdata();
	}
}