<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_About extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_transport_about';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport About', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Slider Option', 'fastrans' ),
			]
		);
        $this->add_control(
			'sub_heading', [
				'label'       => esc_html__( 'Sub Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading', [
				'label'       => esc_html__( 'Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
        $this->add_control(
			'middle_content',
			[
				'label' => esc_html__( 'Middle Content', 'fastrans' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'about_img',
			[
				'label' => esc_html__( 'About Image', 'plugin-name' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'number', [
				'label'       => esc_html__( 'Number', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_content', [
				'label'       => esc_html__( 'About Content', 'fastrans' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_content', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label'       => esc_html__( 'Button Link', 'fastrans' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btm_content', [
				'label'       => esc_html__( 'Bottom Content', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);	
		
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Sub-Heading-Color',
			[
				'label' => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two.style-two .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Sub-Heading-Typography',
				'label' => esc_html__( 'Sub Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two.style-two .title',
			]
		);
		$this->add_control(
			'Heading-Color',
			[
				'label' => esc_html__( 'Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Heading-Typography',
				'label' => esc_html__( 'Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two h2',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .title-column .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .title-column .text',
			]
		);
		$this->add_control(
			'Description-Bottom-Border-Color',
			[
				'label' => esc_html__( 'Description Bottom Border Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .title-column .text:before' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'--Countdown-Style--',
			[
				'label' => esc_html__( 'Countdown Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Countdown-BG-Color',
			[
				'label' => esc_html__( 'Countdown BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .image-column .client-box' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-Color',
			[
				'label' => esc_html__( 'Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .image-column .client-box .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Number-Color',
			[
				'label' => esc_html__( 'Number Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .image-column .client-box .count-box' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Number-Typography',
				'label' => esc_html__( 'Number Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .image-column .client-box .count-box',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .image-column .client-box .counter-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .image-column .client-box .counter-title',
			]
		);
		$this->add_control(
			'--About-Content-Style--',
			[
				'label' => esc_html__( 'About Content Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'About-Content-Color',
			[
				'label' => esc_html__( 'About Content Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .content-column .text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'About-Content-Typography',
				'label' => esc_html__( 'About Content Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .content-column .text p',
			]
		);
		$this->add_control(
			'--Button-Style--',
			[
				'label' => esc_html__( 'Button Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Title-Color',
			[
				'label' => esc_html__( 'Button Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .content-column .learn-more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Title-Typography',
				'label' => esc_html__( 'Button Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .content-column .learn-more',
			]
		);
		$this->add_control(
			'Button-Title-Icon-Color',
			[
				'label' => esc_html__( 'Button Title Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .content-column .learn-more:before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Title-Hover-Color',
			[
				'label' => esc_html__( 'Button Title Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .content-column .learn-more:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_control(
			'--Button-Content-Style--',
			[
				'label' => esc_html__( 'Button Content Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Button-Content-Color',
			[
				'label' => esc_html__( 'Button Content Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .lower-box h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Content-Typography',
				'label' => esc_html__( 'Button Content Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .about-section .lower-box h4',
			]
		);
		$this->add_control(
			'Button-Content-Border-Color',
			[
				'label' => esc_html__( 'Button Content Border Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-section .lower-box h4' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .about-section .lower-box.text-center h4' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
        $sub_heading = $settings['sub_heading'];
        $heading     = $settings['heading'];
        $description     = $settings['description'];
        $about_img     = $settings['about_img']['url'];
        $number     = $settings['number'];
        $title     = $settings['title'];
        $about_content     = $settings['about_content'];
        $btn_content     = $settings['btn_content'];
        $btn_link     = $settings['btn_link'];
        $btm_content     = $settings['btm_content'];
    ?>
    <!-- About Section -->
		<section class="about-section">
			<div class="auto-container">
				<div class="row clearfix">
				
					<!-- Title Column -->
					<div class="title-column col-lg-4 col-md-6 col-sm-12">
						<div class="inner-column">
							<div class="sec-title-two style-two">
								<div class="title"><?php echo esc_html($sub_heading);?></div>
								<h2><?php echo esc_html($heading);?></h2>
							</div>
							<div class="text"><?php echo __($description);?></div>
						</div>
					</div>
					
					<!-- Image Column -->
					<div class="image-column col-lg-4 col-md-12 col-sm-12">
						<div class="inner-column">
							<div class="image">
								<img src="<?php echo esc_url($about_img);?>" alt="" />
								<div class="client-box">
									<span class="icon flaticonv2-team"></span>
									<div class="count-outer count-box">
										<span class="count-text counter"><?php echo esc_attr($number);?></span>+
									</div>
									<div class="counter-title"><?php echo esc_html($title);?></div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- Content Column -->
					<div class="content-column col-lg-4 col-md-6 col-sm-12">
						<div class="inner-column">
							<div class="text">
								<?php echo __($about_content);?>
							</div>
							<a href="<?php echo esc_url($btn_link['url']);?>" class="learn-more"><?php echo esc_html($btn_content);?></a>
						</div>
					</div>
					
				</div>
				
				<!-- Lower Box -->
				<div class="lower-box text-center">
					<h4><?php echo __($btm_content);?></h4>
				</div>
				
			</div>
		</section>
		<!-- End About Section -->
	<?php	
	}

}
