<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use \Elementor\Group_Control_Background;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Tracking_Order extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tracking_order';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Trackign Order', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'feature_section',
				[
					'label' => esc_html__( 'Feature Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'section_bg',
            [
                'label' => esc_html__( 'Background Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_one',
            [
                'label' => esc_html__( 'Shape Image One', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_two',
            [
                'label' => esc_html__( 'Shape Image Two', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Uncomplicated & Fast Deliveries For Courier', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub title here', 'fastrans' ),
                'label_block' => true,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ftn-section-title h2 span::after',
			]
		);

        $this->add_control(
			'content',
			[
				'label' => esc_html__( 'Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'To be travel management leaders in regions in which we operate, innovative technology to improve the customer experience and bring positive change to the market.', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub content here', 'fastrans' ),
                'label_block' => true,
			]
		);

        $this->add_control(
			'shortcode',
			[
				'label' => esc_html__( 'Shortcode', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Type your shortcode here', 'fastrans'),
                'label_block' => true,
			]
		);
        $this->add_control(
            'shortcode_bg',
            [
                'label' => esc_html__( 'Shortcode Background Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
		$this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Tracking Order Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_highlight_color',
			[
				'label'     => esc_html__( 'Title Highlight Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => esc_html__( 'Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-track-order-desc' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'content_typography',
				'label'          => esc_html__( 'Content Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-track-order-desc',
			]
		);

        $this->add_control(
			'form_h',
			[
				'label' => esc_html__( 'Form', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'form_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-track-order-form' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'form_padding',
			[
				'label' => esc_html__( 'Padding', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ftn-track-order-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'ot_input__h',
			[
				'label' => esc_html__( 'Input Field', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
		    'form_input_color',
		    [
		        'label'     => esc_html__('Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-form input' => 'color: {{VALUE}};',
		        ],
		    ]
		);

        $this->add_control(
		    'form_input_bg_color',
		    [
		        'label'     => esc_html__('background Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-form input' => 'background-color: {{VALUE}};',
		        ],
		    ]
		);
    
        
        $this->add_control(
			'ot_button_h',
			[
				'label' => esc_html__( 'Button', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'button_typography',
                'label'          => esc_html__( 'Button Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-track-order-text-area .ewd-otp-submit',
            ]
        );

		
		$this->start_controls_tabs('button_style_tabs');

		//Default style tab start
		$this->start_controls_tab(
		    'btn_style_default',
		    [
		        'label' => esc_html__('Normal', 'fastrans'),
		    ]
		);

		$this->add_control(
		    'button_bg',
		    [
		        'label'     => esc_html__('background Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-text-area .ewd-otp-submit' => 'background-color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);
		$this->add_control(
		    'button_default_text_color',
		    [
		        'label'     => esc_html__('Text Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-text-area .ewd-otp-submit' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);

		$this->end_controls_tab();

		//Hover style tab start
		$this->start_controls_tab(
		    'btn_style_hover',
		    [
		        'label' => esc_html__('Hover', 'fastrans'),
		    ]
		);

		$this->add_control(
		    'button_hover_bg',
		    [
		        'label'     => esc_html__('Background Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-text-area .ewd-otp-submit:hover' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);
		$this->add_control(
		    'button_hover_text_color',
		    [
		        'label'     => esc_html__('Text Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-track-order-text-area .ewd-otp-submit:hover' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);

		$this->end_controls_tabs();
        
        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

    <section id="ftn-track-order" class="ftn-track-order-section position-relative" data-background="<?php echo esc_attr($settings['section_bg']['url']); ?>">

        <?php if(!empty($settings['shape_one']['url'])): ?>
		<span class="ftn-track-shape1 position-absolute"><img src="<?php echo esc_url($settings['shape_one']['url']); ?>" alt="<?php echo esc_attr($settings['shape_one']['alt']); ?>"></span>
        <?php endif; ?>

        <?php if(!empty($settings['shape_two']['url'])): ?>
		<span class="ftn-track-shape2 position-absolute"><img src="<?php echo esc_url($settings['shape_two']['url']); ?>" alt="<?php echo esc_attr($settings['shape_two']['alt']); ?>"></span>
        <?php endif; ?>

		<div class="background_overlay"></div>
		<div class="container">
			<div class="ftn-track-order-content position-relative">

                <?php if(!empty($settings['image']['url'])): ?>
				<div class="ftn-track-order-img position-absolute  wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
					<img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr($settings['image']['alt']); ?>">
				</div>
                <?php endif; ?>
				<div class="ftn-track-order-text-area d-flex justify-content-end">
					<div class="ftn-track-order-text-wrap">
						<div class="ftn-section-title headline  wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">

                        <?php if(!empty($settings['title'])):?>
                        <h2><?php echo $settings['title'];?></h2>
                        <?php endif;?>
						</div>

                        <?php if(!empty($settings['content'])):?>
						<div class="ftn-track-order-desc  wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1500ms">
                            <?php echo esc_html( $settings['content']);?>
						</div>
                        <?php endif;?>

                        <?php if(!empty($settings['shortcode'])):?>
						<div class="ftn-track-order-form  wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1500ms" data-background="<?php echo esc_attr($settings['shortcode_bg']['url']); ?>">
							<?php echo do_shortcode($settings['shortcode']); ?>
						</div>
                        <?php endif;?>
					</div>
				</div>
			</div>
		</div>
	</section>

    <?php 
	
	}

}