<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_team_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Details', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'team_details',
				[
					'label' => esc_html__( 'Team Details', 'fastrans' ),
				]
		);
		$this->add_control(
            'show_pattern_img',
			[
				'label' => __( 'Enable/Disable BG Pattern Image', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable BG Pattern Image', 'fastrans' ),
			]
		);
		$this->add_control(
			'team_image',
			[
			  'label' => __( 'Team Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'designation',
			[
				'label'       => __( 'Designation', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'fastrans' ),
			]
		);
		$this->add_control(
            'team_info', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title' => esc_html__('Experience:', 'fastrans')],
					['block_title' => esc_html__('Email:', 'fastrans')],
					['block_title' => esc_html__('Phone:', 'fastrans')],
					['block_title' => esc_html__('Fax:', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
            'social_info', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['social_link' => esc_html__('#', 'fastrans')],
					['social_link' => esc_html__('#', 'fastrans')],
					['social_link' => esc_html__('#', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'social_icons',
						'label' => esc_html__('Enter The icons', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options'  => get_fontawesome_icons(),
					],
					[
						'name' => 'social_link',
						'label' => __('Button Url', 'diaco'),
						'type' => Controls_Manager::URL,
						'placeholder' => __('https://your-link.com', 'plugin-domain'),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
				'title_field' => '{{social_link}}',
            ]
        );
		$this->add_control(
			'main_heading',
			[
				'label'       => __( 'Main Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Main Heading', 'fastrans' ),
			]
		);
		$this->add_control(
			'description',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$this->add_control(
            'show_skill_area',
			[
				'label' => __( 'Enable/Disable Skill Info', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Skill Info', 'fastrans' ),
			]
		);
		$this->add_control(
        	'skill', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['skill_title' => esc_html__('Communication', 'fastrans')],
						['skill_title' => esc_html__('Consulting', 'fastrans')],
						['skill_title' => esc_html__('Management', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'circle_bg_color',
							'label' => esc_html__('Circle Border Color', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('#ffffff', 'fastrans')
						],
						[
							'name' => 'circle_fill_color',
							'label' => esc_html__('Circle Border Fill Color', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('#f22728', 'fastrans')
						],
						[
							'name' => 'counter_value',
							'label' => esc_html__('Circle Fill Value', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('', 'fastrans')
						],
						[
							'name' => 'skill_title',
							'label' => esc_html__('Skill Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('', 'fastrans')
						],
						[
							'name' => 'skill_text',
							'label' => esc_html__('Skill Description', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'fastrans')
						],
					],
				'title_field' => '{{skill_title}}',
            ]
        );
		$this->add_control(
            'show_form_area',
			[
				'label' => __( 'Enable/Disable Contact Form', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Contact Form', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Main Heading', 'fastrans' ),
			]
		);
		$this->add_control(
			'contact_form_v2',
			[
				'label'       => __( 'Contact Form 7 Url', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Url', 'fastrans' ),
			]
		);
		$this->add_control(
            'show_contact_info_area',
			[
				'label' => __( 'Enable/Disable Info Box', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Contact Info Box', 'fastrans' ),
			]
		);
		$this->add_control(
			'bg_image',
			[
			  'label' => __( 'Info BG Pattern Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'icons',
			[
			  	'label' => esc_html__('Enter Box Info icons', 'fastrans'),
				'label_block' => true,
				'type' => Controls_Manager::SELECT2,
				'options'  => get_fontawesome_icons(),
			]
	    );
		$this->add_control(
			'info_title',
			[
				'label'       => __( 'Box Info Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Box Info Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'info_phone_no',
			[
				'label'       => __( 'Box Info Phone No.', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Box Info Phone No.', 'fastrans' ),
			]
		);
		$this->add_control(
			'info_email_address',
			[
				'label'       => __( 'Box Info Email Address.', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Box Info Email AddressU.', 'fastrans' ),
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Team Details section
	============================================= -->
	<section id="ft-team-details" class="ft-team-details-section page-padding">
		<div class="container">
			<div class="ft-team-details-content position-relative">
				<?php if($settings['show_pattern_img']){ ?>
                <span class="design-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tmd-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
				<?php } ?>
                <div class="row">
					<?php if($settings['team_image']['id']){ ?>
                    <div class="col-lg-5">
						<div class="ft-team-details-img position-relative">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['team_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
						</div>
					</div>
                    <?php } ?>
					<div class="col-lg-7">
						<div class="ft-team-details-text-wrapper headline pera-content">
							<?php if( $settings['title'] || $settings['designation'] || $settings['text'] ){ ?>
                            <div class="ft-team-details-text">
								<?php if( $settings['title'] ){ ?><h3><?php echo wp_kses($settings['title'], true); ?> </h3><?php } ?>
								<?php if( $settings['designation'] ){ ?><span><?php echo wp_kses($settings['designation'], true); ?></span><?php } ?>
								<?php if( $settings['text'] ){ ?><p><?php echo wp_kses($settings['text'], true); ?> </p><?php } ?>
							</div>
							<?php } ?>
                            <div class="ft-team-details-info ul-li-block">
								<ul>
									<?php foreach($settings['team_info'] as $key => $item): ?>
                                    <li><span><?php echo wp_kses($item['block_title'], true);?></span> <?php echo wp_kses($item['block_text'], true);?></li>
									<?php endforeach; ?>
								</ul>
							</div>
							<div class="coming-soon-social d-flex">
								<?php foreach($settings['social_info'] as $key => $item): ?>
                                <a href="<?php echo esc_url($item['social_link']['url']);?>"><i class="fab <?php echo wp_kses($item['social_icons'], true);?>"></i></a>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="ft-team-personal-form-cta-wrapper">
				<div class="row">
					<div class="col-lg-9">
						<div class="ft-team-personal headline pera-content">
							<?php if($settings['main_heading']){ ?><h2 class="title"><?php echo wp_kses($settings['main_heading'], true); ?></h2><?php } ?>
							<?php if($settings['description']){ ?><p><?php echo wp_kses($settings['description'], true); ?></p><?php } ?>
							
							<?php if($settings['show_skill_area']){ ?>
                            <div class="ft-team-personal-skill">
								<div class="row">
									<?php foreach($settings['skill'] as $key => $item): ?>
                                    <div class="col-md-4">
										<div class="ft-team-skill-inner align-items-center d-flex">
											<div class="counter-boxed  headline position-relative">
												<div class="graph-outer">
													<input type="text" class="dial" data-fgColor="<?php echo esc_attr($item['circle_fill_color']);?>" data-bgColor="<?php echo esc_attr($item['circle_bg_color']);?>" data-width="65" data-height="65" data-linecap="round"  value="<?php echo esc_attr($item['counter_value']);?>" >
													<div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['counter_value']);?>" data-speed="3500"></span><?php esc_html_e('%', 'fastrans'); ?></div>
												</div>
											</div>
											<div class="ft-team-skill-text">
												<h3><?php echo wp_kses($item['skill_title'], true);?></h3>
												<p><?php echo wp_kses($item['skill_text'], true);?> </p>
											</div>
										</div>
									</div>
                                    <?php endforeach; ?>
								</div>
							</div>
                            <?php } ?>
                            
                            <?php if($settings['show_form_area']){ ?>
							<div class="ft-team-contact-form-wrapper">
								<div class="ft-team-contact-form">
									<h3><?php echo wp_kses($settings['form_title'], true);?></h3>
									<?php echo do_shortcode($settings['contact_form_v2'], true);?>
								</div>
							</div>
                            <?php } ?>
						</div>
					</div>
					<?php if($settings['show_contact_info_area']){ ?>
                    <div class="col-lg-3">
						<div class="ft-team-personal-cta text-center" <?php if($settings['bg_image']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>"<?php } ?>>
							<div class="ft-team-personal-cta-icon d-flex justify-content-center align-items-center">
								<i class="fal <?php echo wp_kses($settings['icons'], true);?>"></i>
							</div>
							<div class="ft-team-personal-cta-text headline">
								<h3><?php echo wp_kses($settings['info_title'], true);?></h3>
								<span><?php echo wp_kses($settings['info_phone_no'], true);?></span>
								<span><?php echo wp_kses($settings['info_email_address'], true);?></span>
							</div>
						</div>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
	</section>	
	<!-- End of Team Details section
	============================================= -->
    
    <?php 
	
	}

}