<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use \Elementor\Group_Control_Background;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Testimonial_V5 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'our_testimonial_v5';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial V5', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'testimonial_section',
				[
					'label' => esc_html__( 'Testimonial Section', 'fastrans' ),
				]
		);

		$this->add_control(
            'bg_image',
            [
                'label' => esc_html__( 'Background Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

		$this->add_control(
            'testimonial_image',
            [
                'label' => esc_html__( 'Testimonial Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Testimonials', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub title here', 'fastrans' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'What Our Client Reviews', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your title here', 'fastrans'),
                'label_block' => true,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ftn-section-title h2 span::after',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_section_list',
            [
                'label' => __( 'Testimonial List', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'shape_img',
            [
                'label' => esc_html__( 'Shape Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
		$repeater->add_control(
            'tst_quote',
            [
                'label' => esc_html__( 'Quote Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'glox-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'step' => 1,
			]
		);

        $repeater->add_control(
            'testimonial_content',
            [
                'label' => esc_html__( 'Content', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '“We have completed many projects as shown in some of the pictures above, ranging from to
				railways, roadworks, culture projects through to bridges, balconies safety railings. Our involve
				ment ranges from providing transpor”', 'fastrans' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'testimonial_name',
            [
                'label' => esc_html__( 'Name', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Lucy Davies', 'fastrans' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'testimonial_desig',
            [
                'label' => esc_html__( 'Designation', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'CEO, Pharma Company', 'fastrans' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Testimonial List', 'fastrans'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'testimonial_content' => esc_html__( '“We have completed many projects as shown in some of the pictures above, ranging from to
						railways, roadworks, culture projects through to bridges, balconies safety railings. Our involve
						ment ranges from providing transpor”', 'fastrans' ),
                        'testimonial_name' => esc_html__( 'Lucy Davies', 'fastrans' ),
                        'testimonial_desig' => esc_html__( 'Lucy Davies', 'fastrans' ),
                    ]
                ],
                'title_field' => '{{{ testimonial_name }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Section Title Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-section-title .sub-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_highlight_color',
			[
				'label'     => esc_html__( 'Title Highlight Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => esc_html__( 'Testimonial Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'rating_color',
			[
				'label'     => esc_html__( 'Rating Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-area .testimonial-rate li' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tm_content_h',
			[
				'label' => esc_html__( 'Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'tm_content_color',
			[
				'label'     => esc_html__( 'Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-area .testimonial-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_content_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-testimonial-area .testimonial-text',
			]
		);

        $this->add_control(
			'tm_name_h',
			[
				'label' => esc_html__( 'Name', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'tm_name_color',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-area .testimonial-author .tst-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_name_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-testimonial-area .testimonial-author .tst-name',
			]
		);
        $this->add_control(
			'tm_desig_h',
			[
				'label' => esc_html__( 'Designation', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'tm_desig_color',
			[
				'label'     => esc_html__( 'Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-area .testimonial-author .tst-designation' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_desig_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-testimonial-area .testimonial-author .tst-designation',
			]
		);

        $this->add_control(
			'tm_nav_h',
			[
				'label' => esc_html__( 'Silder Nav', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'tm_nav_color',
			[
				'label'     => esc_html__( 'Nav Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-slider-area .carousel_nav button' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tm_nav_hover_color',
			[
				'label'     => esc_html__( 'Nav Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-slider-area .carousel_nav button:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'tm_nav_bg_color',
			[
				'label'     => esc_html__( 'Nav BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-slider-area .carousel_nav button' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tm_nav_hover_bg_color',
			[
				'label'     => esc_html__( 'Nav Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-testimonial-slider-area .carousel_nav button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

    <section id="ftn-testimonial" class="ftn-testimonial-section" data-background="<?php echo esc_attr($settings['bg_image']['url']); ?>">
		<div class="container">
			<div class="ftn-section-title text-center headline wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">

				<?php if(!empty($settings['sub_title'])):?>
				<span class="sub-title text-uppercase"><?php echo esc_html( $settings['sub_title']);?></span>
                <?php endif;?>

                <?php if(!empty($settings['title'])):?>
				<h2><?php echo $settings['title'];?></h2>
                <?php endif;?>
				
				
			</div>
			<div class="ftn-testimonial-content position-relative">
				<div class="ftn-testimonial-img position-absolute wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1500ms">
					<img src="<?php echo esc_url($settings['testimonial_image']['url']); ?>" alt="<?php echo esc_attr($settings['testimonial_image']['alt']); ?>">
				</div>
				<div class="ftn-testimonial-slider-area  wow fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
					<div class="ftn-testimonial-slider">
						<?php foreach($settings['items'] as $item): ?>
						<div class="ftn-testimonial-item">
							<div class="ftn-testimonial-area position-relative" data-background="<?php echo esc_attr($item['shape_img']['url']); ?>">
								<span class="ftn-qt-icon position-absolute"><img src="<?php echo esc_url($item['tst_quote']['url']); ?>" alt="<?php echo esc_attr($item['tst_quote']['alt']); ?>"></span>
								<div class="testimonial-rate ul-li">
									<ul>
                                        <?php for($i - 0; $i < $item['rating']; $i++): ?>
										<li><i class="fas fa-star"></i></li>
                                        <?php endfor; ?>
									</ul>
								</div>

								<?php if(!empty($item['testimonial_content'])): ?>
								<div class="testimonial-text">
									<?php echo esc_html($item['testimonial_content']); ?>
								</div>
								<?php endif; ?>

								<div class="testimonial-author">
									<?php if(!empty($item['testimonial_name'])): ?>
									<span class="tst-name"><?php echo esc_html($item['testimonial_name']); ?></span>
									<?php endif; ?>
									
									<?php if(!empty($item['testimonial_desig'])): ?>
									<span class="tst-designation"><?php echo esc_html($item['testimonial_desig']); ?></span>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<?php endforeach; ?>
					</div>
					<div class="carousel_nav">
						<button type="button" class="ftn-tst-left_arrow"><i class="fal fa-chevron-left"></i></button>
						<button type="button" class="ftn-tst-right_arrow"><i class="fal fa-chevron-right"></i></button>
					</div>
				</div>
			</div>
		</div>
	</section>

    <?php 
	
	}

}