<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Services_V4 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_services_v4';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Services V4', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_services_v4',
			[
				'label' => esc_html__( 'Our Services V4', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
        	'services', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
				'fields' => 
					[
						[
							'name' => 's_title',
							'label' => esc_html__('Title', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 's_description',
							'label' => esc_html__('Service Description', 'fastrans'),
							'type' => Controls_Manager::TEXTAREA,
							'label_block' => true,
						],
					],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'service_style',
			[
				'label' => esc_html__( 'Service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			's_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-4 h4' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-4 h4',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			's_text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-4 p' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 's_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-4 p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'service_section_heading_style',
			[
				'label' => esc_html__( 'Service Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sh_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sh_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 h2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'sh_sub_clr',
			[
				'label'     => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_sub_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();?>
		
        <!-- Start of Service page section
        ============================================= -->
        <section id="ft-service-pag-4" class="ft-service-4">
            <div class="container">
                <?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                <div class="ft-section-title-4 headline pera-content text-left">
                    <?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    <?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
                </div>
                <?php } ?>
                <div class="ft-service-page-items">
                    <div class="row">
                        <?php foreach($settings['services'] as $item):?>
                        <div class="col-lg-4 col-md-6">
                            <div class="ft-service-innerbox-4">
								<span class="hover-shape"></span>
                                <h4><?php echo esc_html($item['s_title']);?></h4>
                                <p><?php echo __($item['s_description']);?></p>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </section>
    	<!-- End of Service page section
        ============================================= -->
                    
        <?php 
	}
}