<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_projects_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_projects_v3',
			[
				'label' => esc_html__( 'Our Projects V3', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true, 
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_project_categories()
				]
		);
        $this->add_control(
            'project_btn',
            [
                'label'       => __( 'Button', 'fastrans' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
                'default' => 'Explore More',
                'placeholder' => __( 'Button Text', 'fastrans' ),
            ]
        );
		$this->add_control(
			'project_btn_link',
			[
				'label' => esc_html__( 'Button Link', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'projects_style',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title .title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'info_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Info Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'info_clr',
			[
				'label'     => esc_html__( 'Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'info_typography',
				'label'          => esc_html__( 'Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'button_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'btn_clr',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .btn-style-three .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_bg_clr',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn-icon_bg_clr',
			[
				'label'     => esc_html__( 'Button Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three .icon' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_hover_clr',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .btn-style-three:hover .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_hover_bg_clr',
			[
				'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_icon_hover_bg_clr',
			[
				'label'     => esc_html__( 'Button Icon Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-three:hover .icon' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .btn-style-three',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'project-style',
            [
                'label' => __( 'Project Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            '_project_title_style_',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Title Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'project_title_clr',
            [
                'label'     => esc_html__( 'Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-block .inner-box .lower-content h4 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'project_title_typo',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .project-block .inner-box .lower-content h4 a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '_project_button_style_',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Button Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'project_btn_clr',
            [
                'label'     => esc_html__( 'Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-block .inner-box .detail' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'project_btn_typo',
                'label'          => esc_html__( 'Button Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .project-block .inner-box .detail',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '_project_icon_style_',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Icon Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'project_icon_clr',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-block .inner-box .image .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'project_icon_bg_clr',
            [
                'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-block .inner-box .image .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_project_hove_style_',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Project Hover Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'project_hover_bg_clr',
            [
                'label'     => esc_html__( 'Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-block .inner-box:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['project_cat'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

        <!-- Projects Section -->
        <div class="projects-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="title"><?php echo $settings['subtitle'] ;?></div>
                    <h2><?php echo $settings['title'] ?></h2>

                </div>
                <div class="project-carousel owl-carousel owl-theme">

            <?php while ( $query->have_posts() ) : $query->the_post(); ?>

                    <!-- Project Block -->
                    <div class="project-block">
                        <div class="inner-box">
                            <div class="image">
                            <?php if(has_post_thumbnail()){ ?>

                                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>">
                                    <?php the_post_thumbnail(); ?>
                                </a>

                            <?php } ?>
                                <div class="icon">
                                    <i aria-hidden="true" class="flaticonv7 <?php echo get_post_meta(get_the_ID(), 'project_icon', true) ?>"></i>
                                </div>
                            </div>
                            <div class="lower-content">
                                <h4><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h4>

                                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>" class="detail"><?php esc_html_e('More Details', 'fastrans')?></a>
                            </div>
                        </div>
                    </div>

            <?php endwhile; ?>

                </div>

                <!-- Button Box -->
                <div class="button-box">
                    <a href="<?php echo $settings['project_btn_link']['url'];?>" class="theme-btn btn-style-three"><?php echo $settings['project_btn'];?> <span class="icon fas fa-angle-double-right"></span></a>
                </div>

            </div>
        </div>
        <!-- End Projects Section -->
                              	
		<?php }
		wp_reset_postdata();
	}
}