<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News_V7 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_latest_news_v7';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Latest News V7', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'latest_news_v3',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 2,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
        $this->add_control(
            'footer_button',
            [
                'label'       => __( 'Footer Button', 'fastrans' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'default' => __('Explore More', 'fastrans'),
                'placeholder' => __( 'Explore More', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_stylw',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'blog_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title .title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_sub_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Sub Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => '_subtitle_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_image_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Image Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_hover_overlay',
			[
				'label'     => esc_html__( 'Image Overlay', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .image' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
            'blog_meta_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Meta Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
		$this->add_control(
			'blog_meta_bg_clr',
			[
				'label'     => esc_html__( 'Blog Meta BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .image .post-info' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_meta_content_clr',
			[
				'label'     => esc_html__( 'Blog Meta Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .image .post-info li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_meta_content_icon_clr',
			[
				'label'     => esc_html__( 'Blog Meta Content Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .image .post-info li .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_meta_content_icon_bg_clr',
			[
				'label'     => esc_html__( 'Blog Meta Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .image .post-info li .icon' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'blog_meta_content__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .news-block .inner-box .image .post-info li',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_info_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Info Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_category_clr',
			[
				'label'     => esc_html__( 'Category Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .lower-content .title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'blog_category__typography',
				'label'          => esc_html__( 'Category Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .news-block .inner-box .lower-content .title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'_blog_title_clr_',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .lower-content h4 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'_blog_title_hover_clr_',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block .inner-box .lower-content h4 a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'blog_title__typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .news-block .inner-box .lower-content h4 a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);

        $this->add_control(
            'blog_details_button_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Details Button Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blog_details_btn_clr',
            [
                'label'     => esc_html__( 'Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-three .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'blog_details_btn_title__typography',
                'label'          => esc_html__( 'Button Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .btn-style-three',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'blog_details_btn_bg_clr',
            [
                'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_details_btn_icon_bg_clr',
            [
                'label'     => esc_html__( 'Button Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_details_button_hover_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Details Button Hover Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blog_details_btn_hover_clr',
            [
                'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_details_btn_hover_bg_clr',
            [
                'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_details_btn_hover_icon_bg_clr',
            [
                'label'     => esc_html__( 'Button Hover Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'blog_explore_more_btn_style',
            [
                'label' => __( 'Button Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'blog_page_btn_clr',
            [
                'label'     => esc_html__( 'Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-one .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'blog_page_btn_title__typography',
                'label'          => esc_html__( 'Button Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .btn-style-one',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'blog_page_btn_bg_clr',
            [
                'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_page_btn_icon_bg_clr',
            [
                'label'     => esc_html__( 'Button Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_page_button_hover_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Button Hover Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blog_page_btn_hover_clr',
            [
                'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-one:hover .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_page_btn_hover_bg_clr',
            [
                'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_page_btn_hover_icon_bg_clr',
            [
                'label'     => esc_html__( 'Button Hover Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

            <!-- News Section -->
            <div class="news-section">
                <div class="auto-container">
                    <div class="sec-title centered">
                        <div class="title"><?php echo $settings['sub_title']; ?></div>
                        <h2><?php echo $settings['title']; ?></h2>
                    </div>
                    <div class="row clearfix">

                <?php while ( $query->have_posts() ) : $query->the_post(); ?>

                        <!-- News Block -->
                        <div class="news-block col-lg-6 col-md-6 col-sm-12">
                            <div class="inner-box">
                                <div class="image">
                                    <a href="<?php echo get_permalink( get_the_id() ); ?>"><?php the_post_thumbnail(); ?></a>
                                    <ul class="post-info">
                                        <li><span class="icon flaticonv7 flaticonv7-calendar"></span><?php echo esc_attr(get_the_date('d M, y')); ?></li>
                                        <li><span class="icon flaticonv7 flaticonv7-face-detection"></span><?php the_author();?></li>
                                        <li><span class="icon far fa-comment-dots"></span><?php comments_number( wp_kses(__('0 Comments' , 'fastrans'), true), wp_kses(__('1 Comment' , 'fastrans'), true), wp_kses(__('% Comments' , 'fastrans'), true)); ?></li>
                                    </ul>
                                </div>
                                <div class="lower-content">
                                    <div class="title"><?php the_category(', '); ?></div>
                                    <h4><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="theme-btn btn-style-three"><?php esc_html_e('Explore More', 'fastrans'); ?> <span class="icon fas fa-angle-double-right"></span></a>
                                </div>
                            </div>
                        </div>

                <?php endwhile; ?>

                    </div>

                    <div class="btn-box text-center">
                        <a href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>" class="theme-btn btn-style-one"><?php echo $settings['footer_button']; ?> <span class="icon fas fa-angle-double-right"></span></a>
                    </div>

                </div>
            </div>
            <!-- End News Section -->
                        
		<?php }
		wp_reset_postdata();
	}
}