<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News_V4 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_latest_news_v4';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Latest News V4', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'quote_info',
            [
                'label' => esc_html__( 'Quote Info', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'quote_img',
			[
				'label'       => __( 'Quote Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'quote_title',
			[
				'label'       => __( 'Quote Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'quote_text',
			[
				'label'       => __( 'Quote Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'btn_text',
			[
				'label'       => __( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'btn_url',
			[
				'label'       => __( 'Button URL', 'fastrans' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true, 
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'latest_news_v4',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_stylw',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'blog_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-4-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-4-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_excerpt',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Excerpt Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_excerpt_clr',
			[
				'label'     => esc_html__( 'Excerpt Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .excerpt-post-4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'excerpt__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .excerpt-post-4',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_date',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Date Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_date_clr',
			[
				'label'     => esc_html__( 'Date Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-4-date' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_date_bg_clr',
			[
				'label'     => esc_html__( 'Date BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-4-date' => 'background: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'date__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .post-4-date',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_readmore_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Readmore Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_readmore_clr',
			[
				'label'     => esc_html__( 'Readmore Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .morev4-btn span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'readmore__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .morev4-btn span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_sub_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_h__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_ttl_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'main_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 h2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'main_ttl_h__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

        <!-- Start of blog  section
        ============================================= -->
        <section id="ft-blog-4" class="ft-blog-section-4 position-relative">
            <div class="container">
				<div class="ft-section-title-4 headline pera-content text-left">
					<?php if($settings['sub_title']){ ?><span class="sub-title"><?php echo wp_kses($settings['sub_title'], true); ?></span><?php } ?>						
					<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>				
				</div>
                <div class="ft-blog-content-4">
					<div class="row">
						<div class="col-lg-8 ft-post-4-slider">
							<?php while ( $query->have_posts() ) : $query->the_post(); ?>
							<div class="ft-4-item-innerbox">
								<div class="ft-blog-innerbox-4 position-relative">
									<div class="ft-blog-4-img">
										<?php the_post_thumbnail('fastrans_371x233'); ?>
										<a class="post-4-date" href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="fas fa-calendar-alt"></i> <?php echo esc_attr(get_the_date()); ?></a>
									</div>
									<div class="ft-blog-4-text headline pera-content position-relative">
										<h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
										<div class="excerpt-post-4">
											<?php echo wp_trim_words(get_the_excerpt(), 20, '')  ;?>
										</div>
										<a class="morev4-btn" href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><span><?php esc_html_e('Read More', 'fastrans'); ?></span> <i class="fal fa-plus"></i></a>
									</div>
								</div>
							</div>
							<?php endwhile; ?>
						</div>
						<div class="col-lg-4">
							<div class="get-quote-item-4">
								<div class="quote4-img">
									<img src="<?php echo esc_url($settings['quote_img']['url']);?>" alt="">
								</div>
								<div class="quote4-content">
									<h4><?php echo esc_html($settings['quote_title']);?></h4>
									<p><?php echo esc_html($settings['quote_text']);?></p>
									<a href="<?php echo esc_url($settings['btn_url']['url']);?>"><?php echo esc_html($settings['btn_text']);?></a>
								</div>
							</div>
						</div>
					</div>
                </div>
            </div>
        </section>
    	<!-- End of blog  section
        ============================================= -->
                        
		<?php }
		wp_reset_postdata();
	}
}