<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_testimonial extends Widget_Base {
 

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_testimonial';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Testimonial', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Testimonial_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
	

		$repeater = new Repeater();

		$repeater->add_control(
			'author_img',
			[
				'label'       => esc_html__( 'Author Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			],
		);
		$repeater->add_control(
			'name',
			[
				'label'       => esc_html__( 'Name', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Abbie Ferguson', 'fastrans'),
			],
		);
		$repeater->add_control(
			'designation',
			[
				'label'       => esc_html__( 'Designation', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('/ CEO & Founder', 'fastrans'),
			],
		);
		$repeater->add_control(
			'ratting',
			[
				'label' => esc_html__( 'Ratting', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'step' => 1,
				'default' => 4,
			],
		);
		$repeater->add_control(
			'ratting_for',
			[
				'label'       => esc_html__( 'Ratting For', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Support', 'fastrans'),
			],
		);
		$repeater->add_control(
			'comment',
			[
				'label'       => esc_html__( 'Comment', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __('He development of reliable and scalable software solutiany OS, browser and device. We bring together deepin expertise and the latest advan.', 'fastrans'),
			],
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Testimonial List', 'fastrans' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
					[
						'name' => esc_html__( 'Abbie Ferguson', 'fastrans' ),
					],
				],
				'title_field' => '{{{ name }}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'Testimonial-style',
			[
				'label' => esc_html__( 'Testimonial Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'Name-color',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-testimonial-block strong' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Name-typography',
				'label'          => esc_html__( 'Name Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-testimonial-block strong',
			]
		);
		$this->add_control(
			'Designation-color',
			[
				'label'     => esc_html__( 'Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-testimonial-block .author-box .box-inner' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Designation-typography',
				'label'          => esc_html__( 'Designation Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-testimonial-block .author-box .box-inner',
			]
		);
		$this->add_control(
			'Comment-color',
			[
				'label'     => esc_html__( 'Comment Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-testimonial-block .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Comment-typography',
				'label'          => esc_html__( 'Comment Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-testimonial-block .text',
			]
		);
		$this->add_control(
			'Nav-Active-color',
			[
				'label'     => esc_html__( 'Nav Active Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-testimonial-section .owl-dots .owl-dot.active, .ft12-testimonial-section .owl-dots .owl-dot:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Nav-InActive-color',
			[
				'label'     => esc_html__( 'Nav Inactive Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-testimonial-section .owl-dots .owl-dot' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- ft12 Testimonial Section -->
        <div class="ft12-testimonial-section">
            <div class="auto-container custom-container-width">
                <div class="testimonial-carousel-two owl-carousel owl-theme">
                
                    <?php foreach ($settings['list'] as $item): ?>
                    <!-- Testimonial Block -->
                    <div class="ft12-testimonial-block">
                        <div class="inner-box">
                            <div class="upper-box">
                                <!-- Author Box -->
                                <div class="author-box">
                                    <div class="box-inner">
                                        <div class="author-image">
                                            <img src="<?php echo esc_url($item['author_img']['url']); ?>" alt="" />
                                        </div>
                                        <strong><?php echo esc_html($item['name']); ?></strong>
										<?php echo esc_html($item['designation']); ?>
                                    </div>
                                </div>
                                <div class="rating">
                                    <?php
                                        if (1 == $item['ratting']){
                                            echo '<span class="fa fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>';
										}elseif (2 == $item['ratting']){
											echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>';
										}elseif (3 == $item['ratting']){
											echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fal fa-star"></span>
                                                <span class="fal fa-star"></span>';
										}elseif (4 == $item['ratting']){
											echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fal fa-star"></span>';
										}else{
											echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>';
										}
                                    ?>
                                </div>
                                <div class="support"><?php echo esc_html($item['ratting_for']); ?></div>
                            </div>
                            <div class="text"><?php echo wp_kses($item['comment'], true); ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>

                </div>
            </div>
        </div>
        <!-- End ft12 Testimonial Section -->
        
	<?php	
	}

}
