<?php

namespace FASTRANSPLUGIN\Element;


class Elementor {
	static $widgets = array(
		//Home Page One
		'updated_services',
		'ft_our_services',
		'ft_about_us',
		'our_services',
		'about_us',
		'our_projects',
		'funfacts',
		'why_choose_us',
		'our_testimonials',
		'latest_news',
		
		//Home Page Two
		'booking_form',
		'about_us_v2',
		'what_we_do',
		'funfacts_v2',
		'why_choose_us_v2',
		'our_team',
		'our_projects_v2',
		'our_testimonials_v2',
		'request_quote_form',
		'latest_news_v2',
		
		//Home Page Three
		'home_three_banner',
		'our_features',
		'request_quote_form_v2',
		'what_we_do_v2',
		'about_us_v3',
		'our_skills',
		'our_projects_v3',
		'our_testimonials_v3',
		'faqs_and_services',
		'latest_news_v3',

		//Home Page Four
		'our_services_v4',
		'our_team_v3',
		'our_skills_v2',
		'cta_section',
		'our_projects_v5',
		'our_awesome_service',
		'our_testimonials_v4',
		'latest_news_v4',

		//Home Page Five
		'transport_slider',
		'transport_contact_info',
		'transport_about',
		'transport_fanfact',
		'transport_service',
		'transport_project_carousel',
		'transport_team',
		'transport_testimonial',
		'transport_cta_widget',
		'transport_post_grid',
		
		//Inner Pages
		'funfacts_v3',
		'our_features_v2',
		'video_section',
		'our_services_v2',
		'service_details',
		'our_projects_v4',
		'project_details',
		'similar_project',
		'our_team_v2',
		'team_details',
		'coming_soon',
		'our_faqs',
		'pricing_plan',
		'contact_us',

        //Home 7
        'tracking_number_v7',
        'welcome_v7',
        'service_v7',
        'client_section_v7',
        'steps_section_v7',
        'request_a_quote_v7',
        'feature_v7',
        'our_projects_v7',
        'testimonial_v7',
        'latest_news_v7',
        'global_location_v7',
        'button_v7',
        'language_v7',

		// Home 9
		'logistic_banner',
		'logistic_service',
		'logistic_video_banner',
		'logistic_team',
		'logistic_contact_section',
		'logistic_latest_news',
		'logistic_testimonial',

		// Home 10
		'feature',
		'about_us_v4',
		'our_services_v5',
		'our_testimonial_v5',
		'latest_news_v8',
		'tracking_order',
		'cost_calculate',
		
		// Home 11
		'home_11_banner',
		'home_11_feature',
		'home_11_about',
		'home_11_service',
		'home_11_portfolio',
		'home_11_request_form',
		'home_11_testimonial',
		'home_11_blog',
		'home_11_client_logo',
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = FASTRANSPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}
			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\FASTRANSPLUGIN\\Element\\' . ucwords( $widget );
			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'fastrans',
			[
				'title' => esc_html__( 'Fastrans', 'fastrans' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Template Path', 'fastrans' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();