<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Coming_Soon extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_coming_soon';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Coming Soon', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'coming_soon',
				[
					'label' => esc_html__( 'Coming Soon', 'fastrans' ),
				]
		);
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'fastrans' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
				'default' => esc_html__('We`re Coming Soon', 'fastrans'),
			]
		);
		$this->add_control(
			'counter_value',
			[
				'label'       => __( 'Counter Value', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Counter Value', 'fastrans' ),
				'default' => esc_html__('2023/12/1', 'fastrans'),
			]
		);
		$this->add_control(
            'show_newsletter_area',
			[
				'label' => __( 'Enable/Disable Newsletter Form', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Newsletter Form', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_id',
			[
				'label'       => __( 'MailChimp Form Url', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your MailChimp Form Url', 'fastrans' )
			]
		);
		$this->add_control(
            'show_social_icons',
			[
				'label' => __( 'Enable/Disable Social Icons', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Social Icons', 'fastrans' ),
			]
		);
		$this->add_control(
              'social_icon', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['social_link' => esc_html__('https://www.facebook.com/', 'fastrans')],
                			['social_link' => esc_html__('https://www.twitter.com/', 'fastrans')],
                			['social_link' => esc_html__('https://www.linkedin.com/', 'fastrans')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'fastrans'),
								'label_block' => true,
                    			'type' => Controls_Manager::SELECT2,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'social_link',
								'label' => __( 'Social Url', 'fastrans' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{social_link}}',
                 ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Coming Soon section
	============================================= -->
	<section id="coming-soon" class="coming-soon-section" <?php if($settings['bg_img']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_img']['id'])); ?>"<?php } ?>>
		<div class="container">
			<div class="coming-soon-content headline pera-content">
				<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
				<div class="coming-soon-countdown ul-li">
					<ul>
						<li class="days">
							<span class="ft-count-down-number"></span>
							<span class="count-unit"><?php esc_html_e('Days', 'fastrans'); ?></span>
						</li>

						<li class="hours">
							<span class="ft-count-down-number"></span>
							<span class="count-unit"><?php esc_html_e('Hours', 'fastrans'); ?></span>
						</li>

						<li class="minutes">
							<span class="ft-count-down-number"></span>
							<span class="count-unit"><?php esc_html_e('Minutes', 'fastrans'); ?></span>
						</li>

						<li class="seconds">
							<span class="ft-count-down-number"></span>
							<span class="count-unit"><?php esc_html_e('Seconds', 'fastrans'); ?></span>
						</li>
					</ul>
				</div>
				<?php if($settings['show_newsletter_area']){ ?>
                <div class="coming-soon-newslatter-form">
					<h3><?php echo wp_kses( $settings['form_title'], true );?></h3>
					<p><?php echo wp_kses( $settings['form_text'], true );?></p>
					<?php echo do_shortcode( $settings['form_id'] );?>
				</div>
				<?php } ?>
                
                <?php if($settings['show_social_icons']){ ?>
                <div class="coming-soon-social d-flex">
					<?php foreach($settings['social_icon'] as $item):?>
                    <a href="<?php echo esc_url($item['social_link']['url']); ?>"><i class="fab <?php echo esc_attr($item['icons']); ?>"></i></a>
                    <?php endforeach;?>
				</div>
                <?php } ?>
			</div>
		</div>
	</section>
	<!-- End of Coming Soon section
	============================================= -->

    <?php 
	
	}

}