<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Button_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'button_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Button V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'button_section',
				[
					'label' => esc_html__( 'Button Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Free Quote', 'fastrans' ),
            ]
        );$this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
        $this->add_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'plugin-name' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'plugin-name' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'plugin-name' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );
		$this->end_controls_section();


		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__( 'Button Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .btn-style-one .icon' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .btn-style-one',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'button_BG_color',
			[
				'label'     => esc_html__( 'Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button_icon_BG_color',
			[
				'label'     => esc_html__( 'Icon Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one .icon' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
            'btn_hover_style__',
            [
                'label' => esc_html__( 'Button Hover Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		$this->add_control(
			'hover_title_color',
			[
				'label'     => esc_html__( 'Hover Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .btn-style-one:hover .icon' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
            'hover_btn_bg_color',
            [
                'label'     => esc_html__( 'Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_btn_icon_bg_color',
            [
                'label'     => esc_html__( 'Hover Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Btn Box -->
        <div class="btn-box" style="text-align: <?php echo esc_attr( $settings['text_align'] ); ?>">
            <a href="<?php echo $settings['button_url']['url']; ?>" class="theme-btn btn-style-one"><?php echo $settings['button_text'] ?> <span class="icon fas fa-angle-double-right"></span></a>
        </div>

    <?php 
	
	}

}