<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_about_us';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'about_us',
				[
					'label' => esc_html__( 'About Us', 'fastrans' ),
				]
		);
		$this->add_control(
			'about_image',
			[
			  'label' => __( 'About Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'signature_image',
			[
			  'label' => __( 'Signature Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'author_title',
			[
				'label'       => __( 'Author Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Author Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'fastrans' ),
			]
		);
		$this->add_control(
            'description', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_text' => esc_html__('Description', 'fastrans')],
					['block_text' => esc_html__('Description', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_text}}',
            ]
        );
		$this->add_control(
			'btn_title1',
			[
				'label'       => __( 'Button Title V1', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title V1', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link1',
			[
				'label' => __( 'Button Url V1', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'btn_title2',
			[
				'label'       => __( 'Button Title V2', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title V2', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link2',
			[
				'label' => __( 'Button Url V2', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'about_style',
			[
				'label' => esc_html__( 'About Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'about_sub_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-3 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'about_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-3 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'about_sub_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'About Sub Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_text_clr',
			[
				'label'     => esc_html__( 'Sub Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-text-3 .ft-about-sub-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-text-3 .ft-about-sub-text',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'about_fe_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'About Feature Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'ab_f_text_clr',
			[
				'label'     => esc_html__( 'Feature Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-text-3 .ft-about-feature-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'fe_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-text-3 .ft-about-feature-text',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'about_btn_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'About Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'ab_btn_clr',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-text-3 .ft-about-btn-group a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'ab_btn_hover_clr',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-text-3 .ft-about-btn-group a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-text-3 .ft-about-btn-group a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of About section
	============================================= -->
	<section id="ft-about-3" class="ft-about-section-3">
		<div class="container">
			<div class="ft-about-content-3">
				<div class="row">
					<div class="col-lg-6">
						<div class="ft-about-img-wrapper-3 position-relative">
							<?php if($settings['about_image']['id']){ ?>
                            <div class="ft-about-img-3">
								<img src="<?php echo esc_url(wp_get_attachment_url($settings['about_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
							</div>
                            <?php } ?>
                            
							<?php if($settings['signature_image']['id'] || $settings['author_title']){ ?>
                            <div class="ft-about-sign-img-text">
								<?php if($settings['signature_image']['id']){ ?>
                                <span class="sign-shape"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/sign-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
								<div class="ft-about-sign-img">
									<img src="<?php echo esc_url(wp_get_attachment_url($settings['signature_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">							
								</div>
								<?php } ?>
                                <?php if($settings['author_title']){ ?>
                                <div class="ft-about-sign-text">
									<span><?php echo wp_kses($settings['author_title'], true); ?></span>
								</div>
                                <?php } ?>
							</div>
                            <?php } ?>
                            
						</div>
					</div>
					<div class="col-lg-6">
						<div class="ft-about-text-3">
							<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                            <div class="ft-section-title-3 headline">
								<?php if( $settings['subtitle'] ){ ?><span class="text-uppercase"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    			<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
                            </div>
                            <?php } ?>
                            <?php if( $settings['text'] ){ ?>
							<div class="ft-about-sub-text">
								<?php echo wp_kses($settings['text'], true)?>
							</div>
                            <?php } ?>
							<div class="ft-about-feature-3">
								<div class="row">
									<?php foreach($settings['description'] as $key => $item): ?>
                                    <div class="col-md-6">
										<div class="ft-about-feature-text">
											<?php echo wp_kses($item['block_text'], true); ?>
										</div>
									</div>
									<?php endforeach; ?>
								</div>
							</div>
                            
							<div class="ft-about-btn-group text-uppercase d-flex">
								<?php if($settings['btn_link1']['url'] and $settings['btn_title1']){ ?>
                                <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link1']['url'])?>"><?php echo wp_kses($settings['btn_title1'], true)?>  <i class="fas fa-arrow-right"></i></a>
                                <?php } ?>
								<?php if($settings['btn_link2']['url'] and $settings['btn_title2']){ ?>
                                <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link2']['url'])?>"><?php echo wp_kses($settings['btn_title2'], true)?>  <i class="fas fa-arrow-right"></i></a>
								<?php } ?>
                            </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End of About section
	============================================= --> 

    <?php 
	
	}

}