<?php
/**
 * Custom Woocommerce shop page.
 */
get_header();
$data  = \FASTRANS\Includes\Classes\Common::instance()->data( 'single' )->get();
?>
<section id="ft-breadcrumb" class="ft-breadcrumb-section position-relative" data-background="'<?php echo esc_url( $data->get( 'banner' ) ); ?>'" style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
    <span class="background_overlay"></span>
    <span class="design-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tmd-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
    <div class="container">
        <div class="ft-breadcrumb-content headline text-center position-relative">
            <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            <div class="ft-breadcrumb-list ul-li">
                <ul>
                    <?php echo fastrans_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>	
<!-- start blog-single-content -->
<section class="blog-single-content shop-page section-padding">
    <div class="container">
        <div class="row blog-with-sidebar woocommerce-wrapper">
            <?php if (is_shop()){?>
            <div class="col col-lg-12 col-md-12 col-sm-12">
                <div class="blog-grids">
		            <?php woocommerce_content(); ?>
                </div>
            </div> <!-- end blog-content -->
                <?php } else{?>
                    <div class="col col-lg-12 col-md-12 col-sm-12">
                        <div class="blog-grids">
                            <?php woocommerce_content(); ?>
                        </div>
                    </div> <!-- end blog-content -->
                <?php }?>
        </div>
    </div> <!-- end container -->
</section>
<?php
get_footer();