<?php
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Color Logo Settings
$white_logo = $options->get( 'white_color_logo' );
$white_logo_dimension = $options->get( 'white_color_logo_dimension' );
// Header logo
$header_type = get_post_meta( get_the_id(), 'header_type', true );
$fs_page_logo = get_post_meta( get_the_id(), 'fs_page_logo', true );

//Mobile Logo Settings
$mobile_logo = $options->get( 'mobile_color_logo' );
$mobile_logo_dimension = $options->get( 'mobile_color_logo_dimension' );

//Header Menu Type
$header_type = get_post_meta( get_the_id(), 'header_type', true );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

<!-- Main Header -->
<header class="main-header header-v6">
    <?php if($options->get('show_topbar_v6')){ ?>
    <!-- Header Top -->
    <div class="header-top">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <!-- Top Left -->
                <div class="top-left pull-left">
                    <?php if($options->get('email_address_v6') || $options->get('address_v6')){ ?>
                    <ul class="top-list">
                        <li><span class="icon flaticon-location"></span><?php echo wp_kses($options->get('address_v6'), true); ?></li>
                        <li><span class="icon flaticon-email"></span><a href="<?php echo esc_url($options->get('email_address_url_v6')); ?>"><?php echo wp_kses($options->get('email_address_v6'), true); ?></a></li>
                    </ul>
                    <?php } ?>
                </div>

                <!-- Top Right -->

                <div class="top-right pull-right">
                    <?php
                    if($options->get('show_language_v6')){
                        $lang_img_6 = $options->get('language_image_v6');
                        ?>
                    <div class="language dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                            <span class="flag-icon"><img src="<?php echo esc_url($lang_img_6['url']); ?>" alt="" /></span><?php echo esc_html($options->get('language_name_v6')); ?><span class="fa fa-angle-down"></span>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                            <li><a class="dropdown-item" href="#"><?php echo esc_html($options->get('language_name_v6_1')); ?></a></li>
                            <li><a class="dropdown-item" href="#"><?php echo esc_html($options->get('language_name_v6_2')); ?></a></li>
                            <li><a class="dropdown-item" href="#"><?php echo esc_html($options->get('language_name_v6_3')); ?></a></li>
                            <li><a class="dropdown-item" href="#"><?php echo esc_html($options->get('language_name_v6_4')); ?></a></li>
                        </ul>
                    </div>

                    <?php } ?>
                </div>

            </div>
        </div>
    </div>
    <?php } ?>
    <!-- Header Upper -->
    <div class="header-upper">
        <div class="auto-container">
            <div class="inner-container clearfix">

                <!-- Logo -->
                <div class="pull-left logo-box">
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url())?>">
                            <?php if ($fs_page_logo['url']){ ?>
                            <img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                            <?php }else{ ?>
                                <img src="<?php echo esc_url(get_template_directory_uri(). '/assets/images/logo/logo-5.png'); ?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                            <?php } ?>
                        </a>
                    </div>
                </div>

                <div class="nav-outer clearfix">
                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><img src="<?php echo get_template_directory_uri(). '/assets/images/icons/menu.png'; ?>" alt="" /></span></div>
                    <!-- Main Menu -->
                    <nav class="main-menu navbar-expand-md">
                        <div class="navbar-header">
                            <!-- Toggle Button -->
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                        </div>

                        <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">

                                <?php
                                if(true == $header_type){
                                    wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'navigation clearfix home-v6-menu-icon',
                                        'depth'=>'3',
//                                        'walker'=> new Bootstrap_walker()
                                    ));
                                }else{
                                    wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'navigation clearfix home-v6-menu-icon',
                                        'depth'=>'3',
//                                        'walker'=> new Bootstrap_walker()
                                    ));
                                }
                                ?>

                        </div>
                    </nav>

                    <!-- Main Menu End-->
                    <div class="outer-box clearfix">

                        <!-- Btn Box -->
                        <div class="btn-box">
                            <a href="<?php echo esc_url($options->get('btn_link_v6')); ?>" class="theme-btn btn-style-one"><?php echo wp_kses($options->get('btn_title_v6'), true); ?><span class="icon fas fa-angle-double-right"></span></a>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <!--End Header Upper-->

    <!-- Sticky Header  -->
    <div class="sticky-header">
        <div class="auto-container clearfix">
            <!--Logo-->
            <div class="logo pull-left">
                <a href="<?php echo esc_url(home_url())?>" title="">
                    <?php if ($fs_page_logo['url']){ ?>
                        <img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                    <?php }else{ ?>
                        <img src="<?php echo esc_url(get_template_directory_uri(). '/assets/images/logo/logo-5.png'); ?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                    <?php } ?>
                </a>
            </div>
            <!--Right Col-->
            <div class="pull-right">
                <!-- Main Menu -->
                <nav class="main-menu">
                    <!--Keep This Empty / Menu will come through Javascript-->
                </nav><!-- Main Menu End-->

                <!-- Main Menu End-->
                <div class="outer-box clearfix">

                    <!-- Btn Box -->
                    <div class="btn-box">
                        <a href="<?php echo esc_url($options->get('btn_link_v6')); ?>" class="theme-btn btn-style-one"><?php echo wp_kses($options->get('btn_title_v6'), true); ?><span class="icon fas fa-angle-double-right"></span></a>
                    </div>

                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><img src="<?php echo get_template_directory_uri(). '/assets/images/icons/menu.png'; ?>" alt="" /></span></div>

                </div>

            </div>
        </div>
    </div><!-- End Sticky Menu -->

    <!-- Mobile Menu  -->
    <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><span class="icon fas fa-times"></span></div>

        <nav class="menu-box">
            <div class="nav-logo">
                <a href="<?php echo esc_url(home_url())?>">
                    <?php if ($fs_page_logo['url']){ ?>
                        <img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                    <?php }else{ ?>
                        <img src="<?php echo esc_url(get_template_directory_uri(). '/assets/images/logo/logo-5.png'); ?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>">
                    <?php } ?>
                </a>
            </div>
            <div class="menu-outer">
                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            </div>
        </nav>
    </div><!-- End Mobile Menu -->

</header>
<!-- End Main Header -->