<?php
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );


// Header
$header_type = get_post_meta( get_the_id(), 'header_type', true );
$logo_header_v11 = $options->get( 'logo_header_v11' );
$mobile_and_sticky_logo_header_v11 = $options->get( 'mobile_and_sticky_logo_header_v11' );
$header_11_logo_dimension = $options->get( 'logo_header_v11_dimension' );
$page_meta_logo = get_post_meta(get_the_ID(), 'fs_page_logo', true);

$logo_type = '';
$logo_text = '';
$logo_typography = '';


?>
<!-- Main Header -->
<header class="ft11-main-header">

    <!-- Header Top -->
    <div class="ft11-header-top">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <!-- Top Left -->
                <div class="ft11-top-left pull-right">
                    <ul class="top-list">
						<?php if($options->get('phone_v11')){ ?>
                        <li><span class="icon flaticon-call"></span><?php echo wp_kses($options->get('phone_v11'), true); ?></li>
						<?php } ?>
						<?php if($options->get('address_v11')){ ?>
                        <li><span class="icon flaticon-location"></span><?php echo wp_kses($options->get('address_v11'), true); ?></li>
                        <?php } ?>
						<?php if($options->get('time_v11')){ ?>
                        <li><span class="icon flaticon-deadline"></span><?php echo wp_kses($options->get('time_v11'), true); ?></li>
                        <?php } ?>
                    </ul>
                </div>

            </div>
        </div>
    </div>

    <!-- Header Upper -->
    <div class="header-upper">
        <div class="auto-container">
            <div class="inner-container clearfix">

                <!-- Logo -->
                <div class="pull-left logo-box">
                    <div class="logo">
                        <?php if (!empty($page_meta_logo) && !empty( $page_meta_logo['url'] )){ ?>
                            <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo $page_meta_logo['url'] ?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
						<?php }elseif (!empty( $logo_header_v11['url'] )) {
                            ?>
							<?php echo fastrans_logo( $logo_type, $logo_header_v11, $header_11_logo_dimension, $logo_text, $logo_typography ); ?>
						<?php }else{ ?>
                            <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo get_template_directory_uri();?>/assets/images/logo/logo-11.png" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
                        <?php } ?>
                    </div>
                </div>

                <div class="nav-outer clearfix">
                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler">
                        <span class="icon">
                            <img src="<?php echo get_template_directory_uri();?>/assets/images/icons/menu.png" alt="" />
                        </span>
                    </div>
                    <!-- Main Menu -->
                    <nav class="main-menu navbar-expand-md">
                        <div class="navbar-header">
                            <!-- Toggle Button -->
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                        </div>

                        <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                            <ul class="navigation clearfix">
								<?php
									if(true == $header_type){
										wp_nav_menu( array(
                                            'theme_location' => 'onepage_menu',
                                            'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}else{
										wp_nav_menu( array(
                                            'theme_location' => 'main_menu',
                                            'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right rrr',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}
								?>
                            </ul>
                        </div>
                    </nav>

                    <!-- Main Menu End-->
                    <div class="outer-box clearfix">
						<?php if(!empty($options->get('btn_label_v11'))): ?>
                            <!-- Btn Box -->
                            <div class="btn-box">
                                <a href="<?php echo esc_url($options->get('btn_label_v11_link')); ?>" class="theme-btn btn-style-one"><?php echo wp_kses($options->get('btn_label_v9'), true); ?> <span class="icon fas fa-angle-double-right"></span></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!--End Header Upper-->

    <!-- Sticky Header  -->
    <div class="sticky-header">
        <div class="auto-container clearfix">
            <!--Logo-->
            <div class="logo pull-left">
				<?php if (!empty($mobile_and_sticky_logo_header_v11['url'])){ ?>
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($mobile_and_sticky_logo_header_v11['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
				<?php }else{ ?>
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo get_template_directory_uri();?>/assets/images/logo/logo-11-mobile.png" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
				<?php } ?>
            </div>
            <!--Right Col-->
            <div class="pull-right">
                <!-- Main Menu -->
                <nav class="main-menu">
                    <!--Keep This Empty / Menu will come through Javascript-->
                </nav><!-- Main Menu End-->

                <!-- Main Menu End-->
                <div class="outer-box clearfix">
                
					<?php if(!empty($options->get('btn_label_v11'))): ?>
                        <!-- Btn Box -->
                        <div class="btn-box">
                            <a href="<?php echo esc_url($options->get('btn_label_v11_link')); ?>" class="theme-btn btn-style-one"><?php echo wp_kses($options->get('btn_label_v9'), true); ?> <span class="icon fas fa-angle-double-right"></span></a>
                        </div>
					<?php endif; ?>

                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><img src="<?php echo get_template_directory_uri();?>/assets/images/icons/menu.png" alt="" /></span></div>

                </div>

            </div>
        </div>
    </div><!-- End Sticky Menu -->

    <!-- Mobile Menu  -->
    <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><span class="icon fas fa-times"></span></div>

        <nav class="menu-box">
            <div class="nav-logo">
				<?php if (!empty($mobile_and_sticky_logo_header_v11['url'])){ ?>
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($mobile_and_sticky_logo_header_v11['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
				<?php }else{ ?>
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo get_template_directory_uri();?>/assets/images/logo/logo-11-mobile.png" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>" title=""></a>
				<?php } ?>
            </div>
            <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
        </nav>
    </div><!-- End Mobile Menu -->

</header>
<!-- End Main Header -->