<?php
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Color Logo Settings
$white_and_orange_logo = $options->get( 'white_and_orange_color_logo' );
$white_and_orange_logo_dimension = $options->get( 'white_and_orange_color_logo_dimension' );

//Mobile Logo Settings
$mobile_logo = $options->get( 'mobile_color_logo' );
$mobile_logo_dimension = $options->get( 'mobile_color_logo_dimension' );

//Header Menu Type
$header_type = get_post_meta( get_the_id(), 'header_type', true );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<!-- Start of header section
	============================================= -->
	<header id="ft-header" class="ft-header-section header-style-three">
		<div class="container">
			<div class="ft-header-content position-relative">
				<?php if($options->get('show_topbar_v1')){ ?>
                <div class="ft-header-top d-flex justify-content-end ul-li">
					<ul>
						<?php if($options->get('address_v1')){ ?><li><a href="<?php echo $options->get('address_v1_url'); ?>" target="_blank"><?php echo wp_kses($options->get('address_v1'), true); ?></a> </li><?php } ?>
                        <?php if($options->get('working_days_v1')){ ?><li><a href="<?php echo $options->get('working_days_v1_url'); ?>" target="_blank"><?php echo wp_kses($options->get('working_days_v1'), true); ?></a></li><?php } ?>
						<?php if($options->get('phone_no_v1')){ ?><li><i class="fa fa-phone"></i> <?php echo wp_kses($options->get('phone_no_v1'), true); ?></li><?php } ?>
					</ul>
				</div>
				<?php } ?>
                <div class="ft-header-main-menu d-flex align-items-center justify-content-between">
					<div class="ft-brand-logo">
						<?php echo fastrans_logo( $logo_type, $white_and_orange_logo, $white_and_orange_logo_dimension, $logo_text, $logo_typography ); ?>
					</div>
					<div class="ft-header-main-menu-cta  d-flex align-items-center">
						<nav class="ft-main-navigation clearfix ul-li">
							<ul id="ft-main-nav" class="nav navbar-nav clearfix">
							
							<?php 
								if(true == $header_type){
									wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false,
									'items_wrap' => '%3$s',
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker()
									));
								}else{
									wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false,
									'items_wrap' => '%3$s',
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker()
									));
								}
								
							?>
							</ul>
						</nav>
                        <?php if($options->get('show_button_v1')){ ?>
						<div class="ft-header-cta-btn">
							<a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($options->get('btn_link_v1')); ?>"><?php echo wp_kses($options->get('btn_title_v1'), true); ?></a>
						</div>
                        <?php } ?>
					</div>
				</div>
				<div class="mobile_menu position-relative">
					<div class="mobile_menu_button open_mobile_menu">
						<i class="fal fa-bars"></i>
					</div>
					<div class="mobile_menu_wrap">
						<div class="mobile_menu_overlay open_mobile_menu"></div>
						<div class="mobile_menu_content">
							<div class="mobile_menu_close open_mobile_menu">
								<i class="fal fa-times"></i>
							</div>
							
                            <div class="m-brand-logo">
								<?php echo fastrans_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?>
							</div>
                            
							<nav class="mobile-main-navigation  clearfix ul-li">
								<ul id="m-main-nav" class="navbar-nav text-capitalize clearfix">
								<?php 
								if(true == $header_type){
								wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false,
									'items_wrap' => '%3$s',
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker()
                                )); 
							}else{
								wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false,
									'items_wrap' => '%3$s',
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker()
                                )); 
							}
								?>
								</ul>
							</nav>
						</div>
					</div>
					<!-- /Mobile-Menu -->
				</div>
			</div>
		</div>
	</header>
	<!-- End of header section
	============================================= -->	