<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'fastrans' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'fastrans' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'fastrans' ),
				'e' => esc_html__( 'Elementor', 'fastrans' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'fastrans' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'fastrans' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'fastrans' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'fastrans' ),
		    'options'  => array(

			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style 1', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',
			    ),
			    'footer_v2'  => array(
				    'alt' => esc_html__( 'Footer Style 2', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer2.png',
			    ),
				'footer_v3'  => array(
				    'alt' => esc_html__( 'Footer Style 3', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer3.png',
			    ),
				'footer_v4'  => array(
				    'alt' => esc_html__( 'Footer Style 4', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer4.png',
			    ),
				'footer_v5'  => array(
				    'alt' => esc_html__( 'Footer Style 5', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer5.png',
			    ),
				'footer_v6'  => array(
				    'alt' => esc_html__( 'Footer Style 6', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer6.png',
			    ),
				'footer_v7'  => array(
				    'alt' => esc_html__( 'Footer Style 7', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer7.png',
			    ),
				'footer_v8'  => array(
				    'alt' => esc_html__( 'Footer Style 8', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer8.png',
			    ),
				'footer_v11'  => array(
				    'alt' => esc_html__( 'Footer Style 11', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer11.png',
			    ),
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v3',
	    ),
		
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		array(
			'id'       => 'footer_bg_img',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		array(
            'id' => 'show_call_to_action_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Call To Action Area', 'fastrans'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
        ),
		array(
			'id'      => 'cta_title_v1',
			'type'    => 'text',
			'title'   => __( 'CTA Title', 'fastrans' ),
			'required' => array( 'show_call_to_action_v1', '=', true ),
		),
		array(
			'id'      => 'cta_text_v1',
			'type'    => 'textarea',
			'title'   => __( 'CTA Text', 'fastrans' ),
			'required' => array( 'show_call_to_action_v1', '=', true ),
		),
		array(
			'id'      => 'cta_btn_title_v1',
			'type'    => 'text',
			'title'   => __( 'CTA Button Title', 'fastrans' ),
			'required' => array( 'show_call_to_action_v1', '=', true ),
		),
		array(
			'id'      => 'cta_btn_link_v1',
			'type'    => 'text',
			'title'   => __( 'CTA Button Link', 'fastrans' ),
			'required' => array( 'show_call_to_action_v1', '=', true ),
		),
		array(
			'id'      => 'copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		/***********************************************************************
								Footer Version 2 Start
		************************************************************************/
		array(
			'id'       => 'footer_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Two Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		array(
			'id'      => 'copyright_text2',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		
		/***********************************************************************
								Footer Version 3 Start
		************************************************************************/
		array(
			'id'       => 'footer_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Three Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		array(
			'id'       => 'footer_bg_img3',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		array(
            'id' => 'show_newslatter_form_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Newsletter Form Area', 'fastrans'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
        ),
		array(
			'id'      => 'newslatter_form_title',
			'type'    => 'textarea',
			'title'   => __( 'Form Title', 'fastrans' ),
			'required' => array( 'show_newslatter_form_v3', '=', true ),
		),
		array(
			'id'      => 'newslatter_form_url',
			'type'    => 'textarea',
			'title'   => __( 'MailChimp Form Url', 'fastrans' ),
			'required' => array( 'show_newslatter_form_v3', '=', true ),
		),
		array(
			'id'      => 'copyright_text3',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),

		/***********************************************************************
								Footer Version 4 Start
		************************************************************************/
		array(
			'id'       => 'footer_v4_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Four Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		array(
			'id'       => 'footer_logo_img4',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer 4 Logo Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert Footer Logo Image', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		
		array(
			'id'      => 'footer_4_sb_title',
			'type'    => 'text',
			'title'   => __( 'Sub Title', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		
		
		array(
			'id'      => 'footer_4_title',
			'type'    => 'text',
			'title'   => __( 'Title', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		array(
			'id'      => 'footer_4_title_link',
			'type'    => 'text',
			'title'   => __( 'Link', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),

		array(
			'id'      => 'footer_4_phonr',
			'type'    => 'text',
			'title'   => __( 'Phone', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		array(
			'id'      => 'footer_4_email',
			'type'    => 'text',
			'title'   => __( 'Email', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),

		/***********************************************************************
								Footer Version 5 Start
		************************************************************************/
		array(
			'id'       => 'footer_v5_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Five Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v5' ),
		),

		array(
			'id'       => 'footer_bg_img5',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v5' ),
		),

		array(
			'id'      => 'copyright_text5',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v5' ),
		),
		
        /***********************************************************************
        Footer Version 6 Start
         ************************************************************************/
        array(
            'id'       => 'footer_v6_settings_section_start',
            'type'     => 'section',
            'indent'      => true,
            'title'    => esc_html__( 'Footer Style Six Settings', 'fastrans' ),
            'required' => array( 'footer_style_settings', '=', 'footer_v6' ),
        ),
        array(
            'id'       => 'footer6_bg_img',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer 6 Background Image', 'fastrans' ),
            'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
            'default'  => '',
            'required' => array( 'footer_style_settings', '=', 'footer_v6' ),
        ),
		array(
			'id'      => 'copyright_text_left_6',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text Left', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v6' ),
			'default' => '© 2021 Fastrans- Logistics Services. All rights reserved.',
		),
		array(
			'id'      => 'copyright_text_Right_6',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Right Right', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v6' ),
			'default' => 'Made by with  Themexriver',
		),
        /***********************************************************************
        Footer Version 8 Start
         ************************************************************************/
        array(
            'id'       => 'footer_v8_settings_section_start',
            'type'     => 'section',
            'indent'      => true,
            'title'    => esc_html__( 'Footer Style Eight Settings', 'fastrans' ),
            'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
        ),
        array(
            'id'       => 'footer8_bg_img',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer 8 Background Image', 'fastrans' ),
            'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
            'default'  => '',
            'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
        ),

		array(
			'id'      => 'copyright_text8',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		array(
			'id'       => 'title_color_v8',
			'type'     => 'color',
			'title'    => __('Title Color', 'fastrans'),
			'default'  => '#FFFFFF',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		array(
			'id'       => 'info_color_v8',
			'type'     => 'color',
			'title'    => __('Info Color', 'fastrans'),
			'default'  => '#9d9d9d',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		array(
			'id'       => 'about_us_button_hover_bg_color_v8',
			'type'     => 'color',
			'title'    => __('About Us Button Hover BG', 'fastrans'),
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		array(
			'id'       => 'copyright_color_v8',
			'type'     => 'color',
			'title'    => __('Copyright Color', 'fastrans'),
			'default'  => '#FFFFFF',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		array(
			'id'       => 'primary_color_v8',
			'type'     => 'color',
			'title'    => __('Primary Color', 'fastrans'),
			'default'  => '#d97500',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v8' ),
		),
		/***********************************************************************
		Footer Version 11 Start
		 ************************************************************************/
		array(
			'id'       => 'footer_v11_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Eleven Settings', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'footer11_bg_img',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer 11 Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert Footer Background Image', 'fastrans' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		
		array(
			'id'      => 'copyright_text11',
			'type'    => 'text',
			'title'   => __( 'Copyright Text', 'fastrans' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'title_color_v11',
			'type'     => 'color',
			'title'    => __('Title Color', 'fastrans'),
			'default'  => '#FFFFFF',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'info_color_v11',
			'type'     => 'color',
			'title'    => __('Info Color', 'fastrans'),
			'default'  => '#9d9d9d',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'about_us_button_hover_bg_color_v11',
			'type'     => 'color',
			'title'    => __('About Us Button Hover BG', 'fastrans'),
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'copyright_color_v11',
			'type'     => 'color',
			'title'    => __('Copyright Color', 'fastrans'),
			'default'  => '#FFFFFF',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
		array(
			'id'       => 'primary_color_v11',
			'type'     => 'color',
			'title'    => __('Primary Color', 'fastrans'),
			'default'  => '#d9262a',
			'validate' => 'color',
			'required' => array( 'footer_style_settings', '=', 'footer_v11' ),
		),
	),
);
