<?php
/**
 * Archive Main File.
 *
 * @package FASTRANS
 * @author  Themexriver
 * @version 1.0
 */
get_header();
global $wp_query;
$data  = \FASTRANS\Includes\Classes\Common::instance()->data( 'archive' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-xl-8 col-lg-7';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>

<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'fastrans_banner', $data );?>
<?php else:?>
<!-- Start of Breadcrumb section
============================================= -->
<section id="ft-breadcrumb" class="ft-breadcrumb-section position-relative" data-background="'<?php echo esc_url( $data->get( 'banner' ) ); ?>'" style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
    <span class="background_overlay"></span>
    <span class="design-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tmd-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
    <div class="container">
        <div class="ft-breadcrumb-content headline text-center position-relative">
            <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            <div class="ft-breadcrumb-list ul-li">
                <ul>
                    <?php echo fastrans_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>	
<!-- End of Breadcrumb section
============================================= -->

<?php endif;?>

<!--Start Blog Page Three-->
<section id="ft-blog-post-feed" class="ft-blog-post-feed-section page-padding">
	<div class="container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'fastrans_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
                
                <div class="thm-unit-test">
                    <div class="ft-blog-post-feed-content">
						<?php
                            while ( have_posts() ) :
                                the_post();
                                fastrans_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                            endwhile;
                            wp_reset_postdata();
                        ?>
                    </div>   
                </div>
                
                <!--Pagination-->
                <div class="ft-pagination-item  ul-li">
                	<?php fastrans_the_pagination( $wp_query->max_num_pages );?>
                </div>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'fastrans_sidebar', $data );
				}
			?>
        </div>
    </div>
</section> 
<!--End blog area--> 
<?php
}
get_footer();
