<?php

use Thrive\Automator\Items\Trigger;
use Thrive\Automator\Items\Email_Data;
use Thrive\Automator\Items\User_Data;
use Thrive\Automator\Items\Data_Object;

class HappyForms_Thrive_Automator_Trigger extends Trigger {

	public static function get_id(): string {
		return 'happyforms/form-submit';
	}

	public static function get_wp_hook(): string {
		return 'happyforms_pending_submission_success';
	}

	public static function get_hook_params_number(): int {
		return 1;
	}

	public static function get_provided_data_objects(): array {
		return [ 
			HappyForms_Thrive_Automator_Data_Object::get_id(),
			User_Data::get_id(), 
			Email_Data::get_id(),
		];
	}

	public static function get_app_id(): string {
		return HappyForms_Thrive_Automator_App::get_id();
	}

	public static function get_name(): string {
		return __( 'Happyforms form submit', 'happyforms' );
	}

	public static function get_description(): string {
		return __( 'Triggers when a Happyforms form is successfully submitted', 'happyforms' );
	}

	public static function get_image(): string {
		return 'https://happyforms.io/assets/img/plugin/icon-128x128.png';
	}

	public static function get_required_trigger_fields() {
		return [ 
			HappyForms_Thrive_Automator_Trigger_Form_Field::get_id() => [
				HappyForms_Thrive_Automator_Trigger_Email_Field::get_id(),
			],
		];
	}

	public function process_params( $params = [] ) {
		$form_field = $this->data[HappyForms_Thrive_Automator_Trigger_Form_Field::get_id()];
		$form_id = $form_field['value'];
		$email_field = $form_field['subfield'][HappyForms_Thrive_Automator_Trigger_Email_Field::get_id()];
		$email_field_id = $email_field['value'];

		$data_objects = array();
		$automation_id = $this->get_automation_id();
		$submission_id = $params[0] ?? null;
		$submission = happyforms_get_message_controller()->get( $submission_id );

		$automation_id = $this->get_automation_id();
		$data_object_classes = Data_Object::get();
		$email_address = '';

		if ( $submission ) {
			if ( $submission['form_id'] != $form_id ) {
				return;
			}

			// Happyforms data
			if ( empty( $data_object_classes[ HappyForms_Thrive_Automator_Data_Object::get_id() ] ) ) {
				$data_objects[ HappyForms_Thrive_Automator_Data_Object::get_id() ] = $submission['parts'];
			} else {
				$data_objects[ HappyForms_Thrive_Automator_Data_Object::get_id() ] = new $data_object_classes[ HappyForms_Thrive_Automator_Data_Object::get_id() ]( $submission['parts'], $automation_id );
			}

			// Email data
			if ( $submission['parts'][$email_field_id] ) {
				$email_address = $submission['parts'][$email_field_id];

				if ( empty( $data_object_classes[Email_Data::get_id()] ) ) {
					$data_objects[Email_Data::get_id()] = [ 
						'email' => $email_address
					];
				} else {
					$data_objects[Email_Data::get_id()] = new $data_object_classes[Email_Data::get_id()]( $email_address, $automation_id );
				}
			}

			// User data
			$user_data = get_user_by( 'email', $email_address );

			if ( ! empty( $user_data ) ) {
				if ( empty( $data_object_classes[User_Data::get_id()] ) ) {
					$data_objects[User_Data::get_id()] = $user_data;
				} else {
					$data_objects[User_Data::get_id()] = new $data_object_classes[User_Data::get_id()]( $user_data, $automation_id );
				}
			}
		}

		return $data_objects;
	}

	public static function sync_trigger_data( $trigger_data ) {
		$form_field = $trigger_data['extra_data'][HappyForms_Thrive_Automator_Trigger_Form_Field::get_id()];
		$form_id = $form_field['value'];

		if ( empty( $form_id ) ) {
			return $trigger_data;
		}

		$form = happyforms_get_form_controller()->get( $form_id );

		if ( empty( $form ) ) {
			return $trigger_data;
		}

		$data_object_id = HappyForms_Thrive_Automator_Data_Object::get_id();
		$data_fields = Data_Object::get_all_filterable_fields( [$data_object_id] );
		$trigger_data['filterable_fields'][$data_object_id] = $data_fields[$data_object_id];
		$custom_fields = [];
		$form_fields = static::filter_filterable_fields( $form['parts'] );

		foreach( $form_fields as $field ) {
			$submission_field_id = $field['id'];
			$submission_field = [
				'id' => $submission_field_id,
				'name' => $field['label'],
				'filters' => ['string_ec'],
				'shortcode_tag' => "%{$submission_field_id}%",
				'primary_key' => false,
			];

			$custom_fields[$submission_field_id] = $submission_field;
		}

		unset( $trigger_data['filterable_fields'][$data_object_id][HappyForms_Thrive_Automator_Trigger_Form_Field::get_id()] );

		$trigger_data['filterable_fields'][$data_object_id] = array_merge( 
			$trigger_data['filterable_fields'][$data_object_id],
			$custom_fields
		);

		return $trigger_data;
	}

	private static function filter_filterable_fields( $fields ) {
		$allowed_field_types = array(
			'single_line_text', 
			'multi_line_text', 
			'email', 
			'website_url', 
			'radio', 
			'checkbox', 
			'select', 
			'number', 
			'phone', 
			'date', 
			'scale', 
			'rating', 
			'payments', 
			'address', 
		);

		$fields = array_filter( $fields, function( $field ) use( $allowed_field_types ) {
			return in_array( $field['type'], $allowed_field_types );
		} );

		return $fields;
	}

}