<?php

class HappyForms_Service_Drip extends HappyForms_Service {

	public $id    = 'drip';
	public $group = 'email';

	public $endpoint_accounts = 'https://api.getdrip.com/v2/accounts';
	public $endpoint_subscriber = 'https://api.getdrip.com/v2/%s/subscribers';
	public $endpoint_custom_fields ='https://api.getdrip.com/v2/%s/custom_field_identifiers';

	public $fields = null;
	public $lists = null;
	public $templates = array();

	public function __construct() {
		$this->label = __( 'Drip', 'happyforms' );
	}

	public function get_default_credentials() {
		return array(
			'key' => '',
		);
	}

	public function set_credentials( $credentials = array(), $raw = array() ) {
		$this->credentials = wp_parse_args( $credentials, $this->get_default_credentials() );
	}

	public function admin_widget( $previous_credentials = array() ) {
		require_once( happyforms_get_integrations_folder() . '/services/drip/partial-widget.php' );
	}

	public function is_connected() {
		$is_connected = ! empty( $this->credentials['key'] );

		return $is_connected;
	}

	public function load() {
		if ( $this->is_connected() ) {
			require_once( happyforms_get_integrations_folder() . '/services/drip/class-integration-drip.php' );
		}
	}

	public function make_request( $method, $endpoint, $body = array() ) {
		$arguments = array(
			'method'  => $method,
			'headers' => array(
				'Authorization' => "Basic " . base64_encode( "{$this->credentials['key']}:" ),
				'Content-Type' => 'application/json',
			)
		);

		if ( $body ) {
			$arguments['body'] = json_encode( $body );
		}

		$response = $this->make_api_request( $endpoint, $arguments );

		$body = wp_remote_retrieve_body( $response );

		$body = json_decode( $body );

		if ( isset( $body->error ) && happyforms_debug_log_enabled() ) {
			$message = '';

			if ( isset( $body->error->code ) ) {
				$message = 'error code: ' . $body->error->code;
			}

			if ( isset( $body->error->message ) ) {
				if ( ! empty( $message ) ) {
					$message .= ' || ';
				}
				$message .= 'message: ' . $body->error->message;
			}

			$error = new WP_Error( $this->id, $message );

			happyforms_log_error( $error );

			return false;
		}

		return $body;
	}

	/**
	 * Get lists.
	 *
	 * @return array Lists.
	 */
	public function get_lists() {
		if ( ! is_null( $this->lists ) ) {
			return $this->lists;
		}
		$key = $this->credentials['key'];

		$endpoint_accounts = $this->endpoint_accounts;

		$response = $this->make_request( 'GET', $endpoint_accounts );

		$this->lists = array();

		if ( ! $response ) {
			return $this->lists;
		}

		if ( ! isset( $response->accounts ) ) {
			return $this->lists;
		}

		if ( is_array( $response->accounts ) ) {
			$this->lists = $response->accounts;
		}

		return $this->lists;
	}

	public function get_standard_fields() {
		$fields = array( array(
			'id' => 'email',
			'name' => __( 'Email', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'first_name',
			'name' => __( 'First name', 'happyforms' ),
			'type' => 'string',
		),array(
			'id' => 'last_name',
			'name' => __( 'Last name', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'address1',
			'name' => __( 'Address 1', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'address2',
			'name' => __( 'Address 2', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'city',
			'name' => __( 'City', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'state',
			'name' => __( 'State', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'zip',
			'name' => __( 'Zip', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'country',
			'name' => __( 'Country', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'phone',
			'name' => __( 'Phone', 'happyforms' ),
			'type' => 'string',
		), array(
			'id' => 'sms_number',
			'name' => __( 'Zip', 'happyforms' ),
			'type' => 'string',
		) );

		return $fields;
	}

	public function get_fields() {
		if ( ! is_null( $this->fields ) ) {
			return $this->fields;
		}

		$account_list = $this->get_lists();
		$standard_fields = $this->get_standard_fields();
		$this->fields = array();

		foreach ( $account_list as $account ) {
			$fields = $standard_fields;
			$account_id = $account->id;
			$endpoint_custom_fields = sprintf( $this->endpoint_custom_fields, $account_id );

			$response = $this->make_request( 'GET', $endpoint_custom_fields );

			if ( isset( $response->custom_field_identifiers ) ) {
				$account_custom_fields = array_diff( $response->custom_field_identifiers, array_column( $fields, 'id' ) );

				foreach ( $account_custom_fields as $field ) {
					$fields[] = array(
						'id' => $field,
						'name' => $field,
						'type' => 'string',
					);
				}
			}

			$this->fields[ $account_id ] = $fields;
		}

		return $this->fields;
	}


	public function create_update_subscriber( $data ) {
		$subscriber_data = [];

		$skip_key = [ 'list_id', 'fields' ];

		foreach ( $data as $key => $value ) {
			if ( in_array( $key, $skip_key ) ) {
				continue;
			}

			$subscriber_data[$key] = $value;
		}

		foreach ( $data['fields'] as $key => $value ) {
			$subscriber_data[$key] = $value;
		}

		$body = array(
			'subscribers' => [ $subscriber_data ],
		);

		$endpoint_subscriber = sprintf( $this->endpoint_subscriber, $data['list_id'] );

		$response = $this->make_request( 'POST', $endpoint_subscriber, $body );

		return $response;
	}
}
