<?php
$service = happyforms_get_integrations()->get_service( 'constant-contact' );
$credentials = $service->get_credentials();
$action = happyforms_get_integrations()->integrations_action;
?>
<form class="happyforms-service hf-ajax-submit">
	<div class="happyforms-integrations-notices"><?php do_action( 'happyforms_integrations_print_notices' ); ?></div>
	<div class="widget-content">
		<?php wp_nonce_field( $action ); ?>
		<input type="hidden" name="action" value="<?php echo $action; ?>">
		<input type="hidden" name="service" value="<?php echo $service->id; ?>">

		<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration">
			<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
				<div class="happyforms-clipboard-field">
					<label for="constant-contact-redirect-uri"><?php _e( 'Redirect URI', 'happyforms' ); ?></label>
					<div class="happyforms-clipboard-field-input-wrapper">
						<input type="text" name="constant-contact-redirect-uri" readonly value="<?php echo $service->redirect_uri; ?>" />
						<div class="happyforms-clipboard">
							<button type="button" class="button happyforms-clipboard__button" data-value="<?php echo $service->redirect_uri; ?>"><?php _e( 'Copy to clipboard', 'happyforms' ); ?></button>
							<span aria-hidden="true" class="hidden"><?php _e( 'Copied!', 'happyforms' ); ?></span>
						</div>
					</div>
				</div>
				<?php
				happyforms_credentials_input(
					$service->id,
					'client_id',
					__( 'API key', 'happyforms' ),
					$credentials['client_id']
				);
				?>
				<?php
				happyforms_credentials_input(
					$service->id,
					'client_secret',
					__( 'API secret', 'happyforms' ),
					$credentials['client_secret']
				);
				?>
				<p>
					<input type="text" value="<?php echo $service->redirect_uri; ?>" id="constant-contact-redirect-url" style="position: absolute; left: -9999px;">
				</p>
			</div>
		</div>
		<div class="widget-control-actions">
			<div class="alignleft">
				<span class="spinner"></span>
				<input type="submit" class="connected button button-primary widget-control-save right" value="<?php _e( 'Save Changes', 'happyforms' ); ?>">
			</div>
			<br class="clear" />
		</div>
	</div>
</form>
