<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class transport_testimonial extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_testimonial';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport testimonial', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_testimonials_v5',
			[
				'label' => esc_html__( 'Our testimonials V5', 'fastrans' ),
			]
		);
        $this->add_control(
            'sub_heading', [
                'label'       => esc_html__( 'Sub heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading', [
                'label'       => esc_html__( 'heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'testimonial_bg', [
                'label'       => esc_html__( 'Background', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'review_bg',
            [
                'label' => esc_html__( 'Review Box BG', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'review_title', [
                'label'       => esc_html__( 'Review Title', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
			'ratting',
			[
				'label' => esc_html__( 'Ratting', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
			]
		);
        
        
        $repeater->add_control(
            'authore_name', [
                'label'       => esc_html__( 'Authore Name', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feedback', [
                'label'       => esc_html__( 'Feedback', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'authore_position', [
                'label'       => esc_html__( 'Position', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'authore_img', [
                'label'       => esc_html__( 'Authore Image', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );  
        
        $this->add_control(
            'testimonial_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ authore_name }}}',
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'testimonial_0style',
			[
				'label' => esc_html__( 'Testimonial Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Quote-Icon-Color',
			[
				'label' => esc_html__( 'Quote Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-block-three .content-column .quote' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Review-Title-Color',
			[
				'label' => esc_html__( 'Review Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-block-three .content-column .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Review-Title-Typography',
				'label' => esc_html__( 'Review Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .testimonial-block-three .content-column .title',
			]
		);
		$this->add_control(
			'Feedback-Color',
			[
				'label' => esc_html__( 'Feedback Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-block-three .content-column .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Feedback-Typography',
				'label' => esc_html__( 'Feedback Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .testimonial-block-three .content-column .text',
			]
		);
		$this->add_control(
			'Name-Color',
			[
				'label' => esc_html__( 'Name Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-block-three .content-column .author' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Name-Typography',
				'label' => esc_html__( 'Name Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .testimonial-block-three .content-column .author',
			]
		);
		$this->add_control(
			'Position-Color',
			[
				'label' => esc_html__( 'Position Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-block-three .content-column .author span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Position-Typography',
				'label' => esc_html__( 'Position Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .testimonial-block-three .content-column .author span',
			]
		);
		$this->add_control(
			'--slider-Nav-style--',
			[
				'label' => esc_html__( 'Slide Nav Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Nav-BG-Color',
			[
				'label' => esc_html__( 'Nav BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-prev' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-next' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'Nav-Icon-Color',
			[
				'label' => esc_html__( 'Nav Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-prev' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-next' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'Nav-Hover-BG-Color',
			[
				'label' => esc_html__( 'Nav Hover BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-prev:hover' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .testimonial-section-three .owl-nav .owl-next:hover' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$testimonial_bg = $settings['testimonial_bg']['url'];
		$testimonial_boxes = $settings['testimonial_boxes'];
        
        ?>
        <!-- Testimonial Section Three -->
        <section class="testimonial-section-three" style="background-image:url(<?php echo esc_url($testimonial_bg);?>)">
                    <div class="auto-container">
                        <div class="single-item-carousel owl-carousel owl-theme">
                            
                            <?php foreach($testimonial_boxes as $box):?>
                            <!-- Testimonial Block Three -->
                            <div class="testimonial-block-three">
                                <div class="inner-box">
                                    <div class="clearfix">
                                        
                                        <div class="content-column col-lg-6 col-md-12 col-sm-12">
                                            <div class="inner-column">
                                                <div class="pattern-layer" style="background-image:url(<?php echo esc_url($box['review_bg']['url']);?>)"></div>
                                                <div class="quote flaticonv2-quote-1"></div>
                                                <div class="title"><?php echo esc_html($box['review_title']);?></div>
                                                <div class="rating">
                                                    <?php for($i=0; $i < $box['ratting']; $i++):?>
                                                        <span class="fa fa-star"></span>
                                                    <?php endfor;?>
                                                </div>
                                                <div class="text"><?php echo __($box['feedback']);?></div>
                                                <div class="author">
                                                    <?php echo esc_html($box['authore_name']);?>
                                                    <span><?php echo esc_html($box['authore_position']);?></span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="image-column col-lg-6 col-md-12 col-sm-12">
                                            <div class="inner-column">
                                                <div class="image">
                                                    <img src="<?php echo esc_url($box['authore_img']['url']);?>" alt="" />
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <?php endforeach;?>
                        </div>
                    </div>
                </section>
                <!-- End Testimonial Section Three -->
        <?php 
	}
    
}