<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Request_A_Quote_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'request_a_quote_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Request Quote V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'request_quote_section',
				[
					'label' => esc_html__( 'Request Quote Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'request_quote',
            [
                'label' => esc_html__( 'Tab Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Request A Quote', 'fastrans' ),
            ]
        );
        $this->add_control(
            'request_quote_form',
            [
                'label' => esc_html__( 'Form Shortcode', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
            ]
        );
        $this->add_control(
            'request_quote_img',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'request_quote_title',
            [
                'label' => esc_html__( 'Request Quote Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Take Your Career To Next Level', 'fastrans' ),
            ]
        );
        $this->add_control(
            'request_quote_info',
            [
                'label' => esc_html__( 'Request Quote Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore', 'fastrans' ),
            ]
        );
        $this->add_control(
            'request_quote_btn',
            [
                'label' => esc_html__( 'Request Quote Button', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Apply Now', 'fastrans' ),
            ]
        );
        $this->add_control(
            'request_quote_btn_url',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'track_track_section',
				[
					'label' => esc_html__( 'Track Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'track_track',
            [
                'label' => esc_html__( 'Tab Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Track & Trace', 'fastrans' ),
            ]
        );
        $this->add_control(
            'track_track_form',
            [
                'label' => esc_html__( 'Form Shortcode', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
            ]
        );
        $this->add_control(
            'track_track_img',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'track_track_title',
            [
                'label' => esc_html__( 'Track & Trace Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Take Your Career To Next Level', 'fastrans' ),
            ]
        );
        $this->add_control(
            'track_track_info',
            [
                'label' => esc_html__( 'Track & Trace Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore', 'fastrans' ),
            ]
        );
        $this->add_control(
            'track_track_btn',
            [
                'label' => esc_html__( 'Track & Trace Button', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Apply Now', 'fastrans' ),
            ]
        );
        $this->add_control(
            'track_track_btn_url',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
		$this->end_controls_section();


		$this->start_controls_section(
			'tab_style',
			[
				'label' => esc_html__( 'Tab Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'tab_title_color',
			[
				'label'     => esc_html__( 'Tab Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .track-tabs .tab-btns .tab-btn' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'tab_title_typography',
                'label'          => esc_html__( 'Tab Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .track-tabs .tab-btns .tab-btn',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'tab_bg',
			[
				'label'     => esc_html__( 'Tab Background', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .track-tabs .tab-btns' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab_active_bg',
			[
				'label'     => esc_html__( 'Tab Active Background', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .track-tabs .tab-btns .tab-btn.active-btn' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab_hover_bg',
			[
				'label'     => esc_html__( 'Tab Hover Background', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .track-tabs .tab-btns .tab-btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'form_style',
            [
                'label' => __( 'Form Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'request_button_color',
            [
                'label'     => esc_html__( 'Request Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .default-form .submit-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'request_button_bg',
            [
                'label'     => esc_html__( 'Request Button Background', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .default-form .submit-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'career_form_bg',
            [
                'label'     => esc_html__( 'Form Career Background', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tracking-section-two .career-column .inner-column:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'career_title',
            [
                'label'     => esc_html__( 'Career Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tracking-section-two .career-column h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'career_title_typography',
                'label'     => esc_html__( 'Career Title Typography', 'fastrans' ),
                'selector' => '{{WRAPPER}} .tracking-section-two .career-column h4',
            ]
        );
        $this->add_control(
            'career_info',
            [
                'label'     => esc_html__( 'Career Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tracking-section-two .career-column .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'career_info_typography',
                'label'     => esc_html__( 'Career Info Typography', 'fastrans' ),
                'selector' => '{{WRAPPER}} .tracking-section-two .career-column .text',
            ]
        );
        $this->add_control(
            'career_apply_btn',
            [
                'label'     => esc_html__( 'Career Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-three .icon' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'career_apply_btnbg_',
            [
                'label'     => esc_html__( 'Career Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'career_apply_btn_icon_bg_',
            [
                'label'     => esc_html__( 'Career Button Icon BG', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'career_apply_btn_hover_bg_',
            [
                'label'     => esc_html__( 'Career Button Hover BG', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'career_apply_btn_icon_hover_bg_',
            [
                'label'     => esc_html__( 'Career Button Icon Hover BG', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Tracking Section -->
        <div class="tracking-section-two">
            <div class="auto-container">
                <div class="inner-container">

                    <!-- Tracking Info Tabs -->
                    <div class="tracking-info-tabs">
                        <!-- Track Tabs -->
                        <div class="track-tabs tabs-box">

                            <!--Tab Btns-->
                            <ul class="tab-btns tab-buttons clearfix">
                                <li data-tab="#prod-quote" class="tab-btn active-btn"><?php echo $settings['request_quote']; ?></li>
                                <li data-tab="#prod-track" class="tab-btn"><?php echo $settings['track_track']; ?></li>
                            </ul>

                            <!--Tabs Container-->
                            <div class="tabs-content">

                                <!-- Tab / Active Tab -->
                                <div class="tab active-tab" id="prod-quote">
                                    <div class="content">
                                        <div class="row clearfix">

                                            <!-- Form Column -->
                                            <div class="form-column col-lg-8 col-md-12 col-sm-12">
                                                <div class="inner-column">

                                                    <!-- Default Form -->
                                                    <div class="default-form">
                                                        <?php echo $settings['request_quote_form']; ?>
                                                    </div>
                                                    <!--End Default Form-->

                                                </div>
                                            </div>

                                            <!-- Career Column -->
                                            <div class="career-column col-lg-4 col-md-12 col-sm-12">
                                                <div class="inner-column" style="background-image:url(<?php echo $settings['request_quote_img']['url']; ?>)">
                                                    <h4><?php echo $settings['request_quote_title']; ?></h4>
                                                    <div class="text"><?php echo $settings['request_quote_info']; ?></div>
                                                    <div class="btn-box">
                                                        <a href="<?php echo $settings['request_quote_btn_url']['url']; ?>" class="theme-btn btn-style-three"><?php echo $settings['request_quote_btn']; ?> <span class="icon fas fa-angle-double-right"></span></a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <!-- Tab -->
                                <div class="tab" id="prod-track">
                                    <div class="content">

                                        <div class="row clearfix">

                                            <!-- Form Column -->
                                            <div class="form-column col-lg-8 col-md-12 col-sm-12">
                                                <div class="inner-column">

                                                    <!-- Default Form -->
                                                    <div class="default-form">
                                                        <?php echo $settings['track_track_form']; ?>
                                                    </div>
                                                    <!--End Default Form-->

                                                </div>
                                            </div>

                                            <!-- Career Column -->
                                            <div class="career-column col-lg-4 col-md-12 col-sm-12">
                                                <div class="inner-column" style="background-image:url(<?php echo $settings['track_track_img']['url']; ?>)">
                                                    <h4><?php echo $settings['track_track_title']; ?></h4>
                                                    <div class="text"><?php echo $settings['track_track_info']; ?></div>
                                                    <div class="btn-box">
                                                        <a href="<?php echo $settings['track_track_btn_url']['url']; ?>" class="theme-btn btn-style-three"><?php echo $settings['track_track_btn']; ?> <span class="icon fas fa-angle-double-right"></span></a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Tracking Section Two -->

    <?php 
	
	}

}