<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Testimonials_V4 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_testimonials_v4';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Testimonials V4', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_testimonials_v4',
			[
				'label' => esc_html__( 'Our Testimonials V4', 'fastrans' ),
			]
		);
        
		$this->add_control(
			'section_img',
			[
				'label'       => __( 'Section BG Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$repeater = new Repeater();
        $repeater->add_control(
			'authore_thumb',
			[
				'label'       => __( 'Authore Thumb', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
			'feedback',
			[
				'label'       => __( 'Feedback', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
			'name',
			[
				'label'       => __( 'Name', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
			'position',
			[
				'label'       => __( 'Position', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $this->add_control(
            'testimonials',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'aw_service_style',
			[
				'label' => esc_html__( 'Content Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'feedback_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Feedback Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'feedback_clr',
			[
				'label'     => esc_html__( 'Feedback Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-testimonial-item-4 p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'feedback_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-testimonial-item-4 p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'name_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Name Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'name_clr',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-testimonial-item-4 h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'name_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-testimonial-item-4 h4',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'postition_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Position  Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_clr',
			[
				'label'     => esc_html__( 'Position Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-testimonial-item-4 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'pos__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-testimonial-item-4 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
           $testimonials =  $settings['testimonials'];
        ?>
		
        <!-- Start of Testimonial section
        ============================================= -->
        <section id="ft-testimonial-4" class="ft-testimonial-section-4" style="background-image:url(<?php echo esc_url($settings['section_img']['url']);?>);">
            <div class="container">
				<div class="row">
					<div class="col-lg-10 offset-lg-1">
						<div class="ft-testimonial-slider-wrapper-4">
							<div class="ft-testimonial-slider-4">
								<?php foreach($testimonials as $item):?>
								<div class="ft-testimonial-item-4 text-center">
									<p><?php echo __($item['feedback']);?></p>
									<img src="<?php echo esc_url($item['authore_thumb']['url']);?>" alt="">
									<h4><?php echo esc_html($item['name']);?></h4>
									<span><?php echo esc_html($item['position']);?></span>
								</div>
								<?php endforeach;?>    
							</div>
						</div>
					</div>
				</div>                
            </div>
        </section>
    	<!-- End of Testimonial section
        ============================================= -->
        
        <?php
	}
}