<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Latest_News extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_logistic_latest_news';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Logistic Latest News', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'latest_news_v3',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		
		$this->add_control(
			'blog_img',
			[
				'label'       => __( 'Left Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_label',
			[
				'label'       => __( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label'       => __( 'Button Link', 'fastrans' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 2,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
        $this->add_control(
            'footer_button',
            [
                'label'       => __( 'Footer Button', 'fastrans' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'default' => __('Explore More', 'fastrans'),
                'placeholder' => __( 'Explore More', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_stylw',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'blog_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-blog-top-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-blog-top-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		
		
        $this->add_control(
            'blog_meta_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Meta Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );
		$this->add_control(
			'blog_meta_bg_clr',
			[
				'label'     => esc_html__( 'Blog Meta BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-date, .tl-thx-blog-item .tl-thx-blog-title-meta .tl-thx-blog-meta a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'date_st_cl',
			[
				'label'     => esc_html__( 'Date Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-date span' => 'color: {{VALUE}}',
				],
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'date_typo_set',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-date span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'blog_meta_content__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-date, .tl-thx-blog-item .tl-thx-blog-title-meta .tl-thx-blog-meta a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_info_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Info Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'_blog_title_clr_',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-title-meta h3' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'blog_title__typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-blog-item .tl-thx-blog-title-meta h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);

        $this->add_control(
            'blog_details_button_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__( 'Blog Details Button Style', 'fastrans' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blog_details_btn_clr',
            [
                'label'     => esc_html__( 'Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tl-thx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'blog_btn_bg_clr',
            [
                'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tl-thx-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'blog_details_btn_title__typography',
                'label'          => esc_html__( 'Button Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .tl-thx-btn a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

            <!-- Start of Blog section
            ============================================= -->
            <section id="tl-thx-blog" class="tl-thx-blog-section">
                <div class="container">
                    <div class="tl-thx-blog-content">
                        <div class="tl-thx-blog-top-content d-flex justify-content-between  wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="tl-thx-blog-top-text">
                                <h3><?php echo wp_kses( $settings['title'], true )?></h3>
                            </div>
                            <div class="tl-thx-btn d-flex">
                                <a class="d-flex justify-content-center align-items-center text-uppercase" href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses( $settings['btn_label'], true )?> <i class="far fa-arrow-right"></i></a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6  wow fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="tl-thx-blog-img-wrapper headline position-relative">
                                    <div class="tl-thx-blog-img">
                                        <img src="<?php echo esc_url($settings['blog_img']['url']); ?>" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="tl-thx-blog-feed-wrapper">
                                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                                    <div class="tl-thx-blog-item d-flex align-items-center  wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="tl-thx-blog-date">
                                            <span><?php echo esc_attr(get_the_date('d')); ?></span>
                                            <?php echo esc_attr(get_the_date('F Y')); ?>
                                        </div>
                                        <div class="tl-thx-blog-title-meta headline">
                                            <h3><a href="<?php echo get_permalink( get_the_id() ); ?>"><?php the_title(); ?></a></h3>
                                            <div class="tl-thx-blog-meta">
                                                <a href="#"><?php the_category(', '); ?></a>
                                                <a href="#"><?php esc_html_e( 'by', 'fastrance' );?> <?php the_author();?></a>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>	
        <!-- End of Blog section
            ============================================= -->
                        
		<?php }
		wp_reset_postdata();
	}
}