<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Contact_Section extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_contact_section';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Logistic Contact Section', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'contact_section',
			[
				'label' => esc_html__( 'Contact Section Option', 'fastrans' ),
			]
		);
		
		$this->add_control(
			'shape_1', [
				'label'       => esc_html__( 'Shape Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'shape_2', [
				'label'       => esc_html__( 'Shape 2', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'shape_3', [
				'label'       => esc_html__( 'Shape 3', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'phone', [
				'label'       => esc_html__( 'Phone', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'email', [
				'label'       => esc_html__( 'Email', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'contact_form_shortcode', [
				'label'       => esc_html__( 'Form Shortcode', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();

        $this->start_controls_section(
			'slider_banner_style',
			[
				'label' => esc_html__( 'Info Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'hd_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'sec_bg_title_cl',
			[
				'label'     => esc_html__( 'Title Shape Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2:before, .tl-thx-section-title h2:after, .tl-thx-section-title h2 i' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_sec_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_desc_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Description Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sec_desc_cl',
			[
				'label'     => esc_html__( 'Section Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sec_desc_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_contact_info_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'COntact Info Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'contact_info_cl',
			[
				'label'     => esc_html__( 'Contact Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-contact-info li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'con_info__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-contact-info li',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'form_btn_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Form Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'form_btn_cl',
			[
				'label'     => esc_html__( 'Form Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-contact-form button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'form_btn_bg_cl',
			[
				'label'     => esc_html__( 'Form Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-contact-form button' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'form_btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-contact-form button',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
    ?>
        <section id="tl-thx-contact" class="tl-thx-contact-section">
            <div class="container">
                <div class="tl-thx-contact-content position-relative">
                    <span class="tl-thx-contact-img position-absolute"><img src="<?php echo esc_url($settings['shape_1']['url']);?>" alt=""></span>
                    <span class="tl-thx-contact-img2 position-absolute  wow fadeInRight" data-wow-delay="200ms" data-wow-duration="2000ms"><img src="<?php echo esc_url($settings['shape_2']['url']);?>" alt=""></span>
                    <div class="tl-thx-contact-text-form">
                        <div class="tl-thx-contact-text-area">
                            <div class="tl-thx-section-title headline text-left pera-content">
                                <h2><i></i><?php echo wp_kses( $settings['title'], true );?></h2>
                                <p><?php echo wp_kses( $settings['description'], true );?></p>
                                <span class="tl-thx-contact-line"><img src="<?php echo esc_url($settings['shape_3']['url']);?>"></span>
                            </div>
                            <div class="tl-thx-contact-info ul-li-block">
                                <ul>
                                    <li><i class="flaticon-call"></i> <?php echo esc_html($settings['phone']);?></li>
                                    <li><i class="fal fa-envelope"></i> <?php echo esc_html($settings['email']);?></li>
                                </ul>
                            </div>
                            <div class="tl-thx-contact-form-wrapper">
                                <div class="tl-thx-contact-form">
                                    <?php echo do_shortcode( $settings['contact_form_shortcode'] );?>
                                </div>
                            </div>
                        </div>	
                    </div>
                </div>
            </div>
        </section>
	<?php	
	}

}
