<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_latest_news_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Latest News V2', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'latest_news_v2',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'fastrans' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Title', 'fastrans' ),
            ]
        );
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
		
		//Blog With Image
		$this->start_controls_section(
            'grid_view',
            [
                'label' => esc_html__( 'Post Grid View', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::NUMBER,
                'default' => 11,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'fastrans' ),
                    'title'      => esc_html__( 'Title', 'fastrans' ),
                    'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
                    'rand'       => esc_html__( 'Random', 'fastrans' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'fastrans' ),
                    'ASC'  => esc_html__( 'ASC', 'fastrans' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'fastrans'),
				'label_block' => true,
                'options' => get_blog_categories()
            ]
        );
        $this->end_controls_section();
		
		//Blog List View
		$this->start_controls_section(
            'list_view',
            [
                'label' => esc_html__( 'Post List View', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'text_limit2',
            [
                'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::NUMBER,
                'default' => 11,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_numbers',
            [
                'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderbys',
            [
                'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'fastrans' ),
                    'title'      => esc_html__( 'Title', 'fastrans' ),
                    'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
                    'rand'       => esc_html__( 'Random', 'fastrans' ),
                ),
            ]
        );
        $this->add_control(
            'query_orders',
            [
                'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'fastrans' ),
                    'ASC'  => esc_html__( 'ASC', 'fastrans' ),
                ),
            ]
        );
        $this->add_control(
            'query_categorys',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'fastrans'),
				'label_block' => true,
                'options' => get_blog_categories()
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'bost_section_heading_style',
			[
				'label' => esc_html__( 'Post Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'postv2_sub_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title .sub-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'postv2_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
			'bost__style',
			[
				'label' => esc_html__( 'Post Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'postv2_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-news-feed-innerbox .ft-blog-feed-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'post_title_hover_clr',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-news-feed-innerbox .ft-blog-feed-text h3:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'post_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-news-feed-innerbox .ft-blog-feed-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
			'postv2_meta_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Meta Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_meta_clr',
			[
				'label'     => esc_html__( 'Meta Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-news-feed-innerbox .ft-blog-feed-text .ft-blog-data a, .ft-blog-news-feed-innerbox .ft-blog-feed-text .ft-blog-comment-view a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'post_meata_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-news-feed-innerbox .ft-blog-feed-text .ft-blog-data a, .ft-blog-news-feed-innerbox .ft-blog-feed-text .ft-blog-comment-view a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => fastrans_set( $settings, 'query_number' ),
            'orderby'        => fastrans_set( $settings, 'query_orderby' ),
            'order'          => fastrans_set( $settings, 'query_order' ),
            'paged'         => $paged
        );
		
        if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
		
		//Second Query
		$args2 = array(
            'post_type'      => 'post',
            'posts_per_page' => fastrans_set( $settings, 'query_numbers' ),
            'orderby'        => fastrans_set( $settings, 'query_orderbys' ),
            'order'          => fastrans_set( $settings, 'query_orders' ),
            'paged'         => $paged
        );
		
        if( fastrans_set( $settings, 'query_categorys' ) ) $args2['category_name'] = fastrans_set( $settings, 'query_categorys' );
        $query2 = new \WP_Query( $args2 );
		
        if ( $query->have_posts() ) { ?>
	
    	<!-- Start of Blog section
        ============================================= -->
        <section id="ft-blog" class="ft-blog-section">
            <div class="container">
                <div class="ft-blog-top-content d-flex justify-content-between align-items-end flex-wrap">
                    <?php if($settings['subtitle'] || $settings['title']){ ?>
                    <div class="ft-section-title headline pera-content">
                        <?php if($settings['subtitle'] || $settings['title']){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true); ?></span><?php } ?>
                        <?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
                    </div>
                    <?php } ?>
                    
                    <?php if($settings['btn_link']['url'] || $settings['btn_title']){ ?>
                    <div class="ft-btn">
                        <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo wp_kses($settings['btn_title'], true); ?></a>
                    </div>
                    <?php } ?>
                </div>
                <div class="ft-blog-feed-content">
                    <div class="row">
                        <div class="col-lg-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                            <div class="ft-blog-feed-wrapper">
                                <div class="ft-blog-news-feed-innerbox">
                                    <div class="ft-blog-feed-img">
                                        <?php the_post_thumbnail('fastrans_570x310'); ?>
                                    </div>
                                    <div class="ft-blog-feed-text headline pera-content">
                                        <div class="ft-blog-meta d-flex justify-content-between flex-wrap">
                                            <div class="ft-blog-data">
                                                <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="far fa-calendar-alt"></i> <?php echo esc_attr(get_the_date('')); ?></a>
                                            </div>
                                            <div class="ft-blog-comment-view">
                                                <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><i class="far fa-comments"></i> <?php comments_number( wp_kses(__('0 Comments' , 'fastrans'), true), wp_kses(__('1 Comment' , 'fastrans'), true), wp_kses(__('% Comments' , 'fastrans'), true)); ?></a>
                                            </div>
                                        </div>
                                        <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                        <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit']), true); ?> </p>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                        <div class="col-lg-6">
                            <div class="ft-blog-feed-wrapper-2">
                                <?php while ( $query2->have_posts() ) : $query2->the_post(); ?>
                                <div class="ft-blog-news-feed-innerbox wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="ft-blog-feed-img">
                                        <?php the_post_thumbnail('fastrans_200x169'); ?>
                                    </div>
                                    <div class="ft-blog-feed-text headline pera-content">
                                        <div class="ft-blog-meta d-flex justify-content-between flex-wrap">
                                            <div class="ft-blog-data">
                                                <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="far fa-calendar-alt"></i> 28 Aug, 2021</a>
                                            </div>
                                            <div class="ft-blog-comment-view">
                                                <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><i class="far fa-comments"></i> <?php comments_number( wp_kses(__('0 Comments' , 'fastrans'), true), wp_kses(__('1 Comment' , 'fastrans'), true), wp_kses(__('% Comments' , 'fastrans'), true)); ?></a>
                                            </div>
                                        </div>
                                        <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                        <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit2']), true); ?> </p>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    	<!-- End of Blog section
        ============================================= -->
    	
        
        <?php }

        wp_reset_postdata();
    }
}
