<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_blog extends Widget_Base {
 


	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_blog';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Blog', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Blog_option',
			[
				'label' => esc_html__( 'Blog Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Latest News & blog', 'fastrans' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'We are Experienced Movers <span>Focused on Quality</span>', 'fastrans' ),
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'The easiest way to save money on a move is to simply get rid of the <br> unnecessary household items. Start the pre-move purging process early <br> by cleaning out your in oxer niost closet.', 'fastrans' ),
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Blog List', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
                'description' => __('Use Max 3 Blog', 'fastrans'),
				'item_actions' => [
					'add' => false,
					'duplicate' => false,
					'remove' => false,
					'sort' => true,
				],
				'fields' => [
				        
                    [
                        'name' => 'blog_id',
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => array_key_first($this->blog_ids()),
						'options' => $this->blog_ids(),
                        'label_block' => true
                    ]
					
				],
				'default' => [
					[
					],
					[
					],
					[
					],
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'Blog-style',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'Title-color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .title',
			]
		);
		$this->add_control(
			'Sub-Title-color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Sub-Title-typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title h2',
			]
		);
		$this->add_control(
			'Description-color',
			[
				'label'     => esc_html__( 'Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Description-typography',
				'label'          => esc_html__( 'Description Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Blog Content Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Image-Hover-Overlay-color',
			[
				'label'     => esc_html__( 'Image Hover Overlay Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-news-block .image' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Meta-color',
			[
				'label'     => esc_html__( 'Meta Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-news-block .post-info li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Meta-typography',
				'label'          => esc_html__( 'Meta Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-news-block .post-info li',
			]
		);
		$this->add_control(
			'Blog-Title-color',
			[
				'label'     => esc_html__( 'Blog Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-news-block h5 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Blog-Title-typography',
				'label'          => esc_html__( 'Blog Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-news-block h5 a',
			]
		);
		$this->add_control(
			'Blog-Title-Hover-color',
			[
				'label'     => esc_html__( 'Blog Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-news-block h5 a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	public function blog_ids()
	{
		$args = array(
			'post_type'   => 'post',
			'posts_per_page' => -1,
		);
		$all_posts = get_posts( $args );
		
		$post_title = [];
		foreach ($all_posts as $post){
			$post_title[$post->ID] = $post->post_title;
		}
		return $post_title;
    }
    
    
	protected function render() {
		$settings = $this->get_settings_for_display();
		
    ?>
        <!-- News Section -->
        <div class="ft12-news-section">
            <div class="auto-container custom-container-width">
                <!-- Sec Title -->
                <div class="ft12-sec-title">
                    <div class="d-flex justify-content-between flex-wrap">
                        <div class="left-box">
                            <div class="title"><?php echo esc_html($settings['title']); ?></div>
                            <h2><?php echo wp_kses($settings['sub_title'], true); ?></h2>
                        </div>
                        <div class="right-box">
                            <div class="text"><?php echo wp_kses($settings['description'], true); ?></div>
                        </div>
                    </div>
                </div>
                <div class="row clearfix">
                    <?php
                        $i = 0;
                        foreach ($settings['list'] as $item):
                        $i++;
                    ?>
                    <?php if (1 == $i): ?>
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <!-- News Block -->
                        <div class="ft12-news-block">
                            <div class="inner-box">
                                <div class="image">
									<?php echo get_the_post_thumbnail($item['blog_id']); ?>
                                </div>
                                <div class="lower-content">
                                    <ul class="post-info">
                                        <li><span class="icon flaticonv7 flaticonv7-calendar"></span><?php echo esc_html(get_the_date('M d Y', $item['blog_id'])) ?></li>
                                        <li><span class="icon flaticon-face-detection"></span>
                                            <?php
                                                $author_id = get_post_field ('post_author', $item['blog_id']);
												the_author_meta('display_name', $author_id);
                                            ?>
                                        </li>
                                    </ul>
                                    <h5><a href="<?php echo esc_url(get_the_permalink($item['blog_id'])); ?>"><?php echo wp_kses(get_the_title($item['blog_id']), true); ?></a></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; ?>
					
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
						<?php
							$i = 0;
							foreach ($settings['list'] as $item):
							$i++;
						?>
                        <?php if (2 == $i): ?>
                        <!-- News Block -->
                        <div class="ft12-news-block-two">
                            <div class="inner-box">
                                <div class="image">
									<?php echo get_the_post_thumbnail($item['blog_id']); ?>
                                </div>
                                <div class="content-box">
                                    <ul class="post-info">
                                        <li><span class="icon flaticonv7 flaticonv7-calendar"></span><?php echo esc_html(get_the_date('M d Y', $item['blog_id'])) ?></li>
                                        <li><span class="icon flaticon-face-detection"></span>
											<?php
												$author_id = get_post_field ('post_author', $item['blog_id']);
												the_author_meta('display_name', $author_id);
											?>
                                        </li>
                                    </ul>
                                    <h5><a href="<?php echo esc_url(get_the_permalink($item['blog_id'])); ?>"><?php echo wp_kses(get_the_title($item['blog_id']), true); ?></a></h5>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <!-- News Block -->
						<?php if (3 == $i): ?>
                            <!-- News Block -->
                            <div class="ft12-news-block-two">
                                <div class="inner-box">
                                    <div class="image">
										<?php echo get_the_post_thumbnail($item['blog_id']); ?>
                                    </div>
                                    <div class="content-box">
                                        <ul class="post-info">
                                            <li><span class="icon flaticonv7 flaticonv7-calendar"></span><?php echo esc_html(get_the_date('M d Y', $item['blog_id'])) ?></li>
                                            <li><span class="icon flaticon-face-detection"></span>
												<?php
													$author_id = get_post_field ('post_author', $item['blog_id']);
													the_author_meta('display_name', $author_id);
												?>
                                            </li>
                                        </ul>
                                        <h5><a href="<?php echo esc_url(get_the_permalink($item['blog_id'])); ?>"><?php echo wp_kses(get_the_title($item['blog_id']), true); ?></a></h5>
                                    </div>
                                </div>
                            </div>
						<?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- End News Section -->
        
	<?php	
	}

}


