<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_banner extends Widget_Base {
 
 

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_banner';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Banner', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_slider',
			[
				'label' => esc_html__( 'Banner Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'slider_image',
			[
				'label'       => esc_html__( 'Slider Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Welcome to Fastans', 'fastrans'),
			],
		);
		$repeater->add_control(
			'sub_title',
			[
				'label'       => esc_html__( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default' => __('Fast & Secure Move <span>is Our Promise</span>', 'fastrans'),
			]
		);
		$repeater->add_control(
			'feature_list',
			[
				'label'       => esc_html__( 'Feature List', 'fastrans' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default' => __('<ul class="check-list">
							<li>We work hard to keep secure</li>
							<li>The average cost of a local</li>
							<li>The price range for hiring</li>
						</ul>', 'fastrans'),
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('contact now', 'fastrans'),
			],
		);
		$repeater->add_control(
			'button_link',
			[
				'label' => esc_html__( 'Button Link', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Slider List', 'fastrans' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title' => esc_html__( 'Welcome to Fastans', 'fastrans' ),
					],
					[
						'title' => esc_html__( 'Welcome to Fastans', 'fastrans' ),
					],
					[
						'title' => esc_html__( 'Welcome to Fastans', 'fastrans' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
		
		
		
		$this->end_controls_section();
        $this->start_controls_section(
			'slider_banner_style',
			[
				'label' => esc_html__( 'Banner Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Banner Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .main-slider-six .title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_Sub_title_cl',
			[
				'label'     => esc_html__( 'Banner Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six h1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_Sub_title_typography',
				'label'          => esc_html__( 'Sub Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .main-slider-six h1',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Feature_list_color',
			[
				'label'     => esc_html__( 'Feature list color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .check-list li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Feature_list_typo',
				'label'          => esc_html__( 'Feature list typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .main-slider-six .check-list li',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Button_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Button_cl',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .button-box .contact-btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Button_typography',
				'label'          => esc_html__( 'Button Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .main-slider-six .button-box .contact-btn',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Button_Hover_cl',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .button-box .contact-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Button_Hover_typography',
				'label'          => esc_html__( 'Button Hover Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .main-slider-six .button-box .contact-btn:hover',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Slider_Nav_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Slider Nav Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Slider_Nav_BG_Color',
			[
				'label'     => esc_html__( 'Slider Nav BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .owl-nav .owl-prev, .main-slider-six .owl-nav .owl-next' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Slider_Nav_Hover_BG_Color',
			[
				'label'     => esc_html__( 'Slider Nav Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-six .owl-nav .owl-prev:hover, .main-slider-six .owl-nav .owl-next:hover' => 'background-color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Main Section Six -->
        <div class="main-slider-six">
            <div class="main-slider-carousel owl-carousel owl-theme">
            <?php foreach ($settings['list'] as $item): ?>
                <!-- Slide One -->
                <div class="slide" style="background-image: url(<?php echo esc_url($item['slider_image']['url']); ?>)">
                    <div class="auto-container">
                        <div class="row clearfix">
                            <!-- Empty Column -->
                            <div class="empty-column col-xl-6 col-lg-4 col-md-12 col-sm-12">
                                <div class="inner-column">

                                </div>
                            </div>

                            <!-- Content Column -->
                            <div class="content-column col-xl-6 col-lg-8 col-md-12 col-sm-12">
                                <div class="inner-column">
                                    <div class="title"><?php echo esc_html($item['title']); ?></div>
                                    <h1><?php echo wp_kses($item['sub_title'], true); ?></h1>
                                    <?php echo wp_kses($item['feature_list'], true); ?>
                                    
                                    <?php if ($item['button_text']): ?>
                                        <div class="button-box">
                                            <a class="theme-btn contact-btn" href="<?php echo esc_url($item['button_link']['url']); ?>"><?php echo esc_html($item['button_text']); ?></a>
                                        </div>
                                    <?php endif; ?>
                                    
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- End Slide One -->
            <?php endforeach; ?>
            </div>
        </div>
        <!-- End Main Section Six -->
	<?php	
	}

}
