<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Funfacts_V3 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_funfacts_v3';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Funfacts V3', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'funfacts_v3',
			[
				'label' => esc_html__( 'Funfacts V3', 'fastrans' ),
			]
		);
		$this->add_control(
        	'funfact', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Parcel Delivered', 'fastrans')],
						['block_title' => esc_html__('Total Branch', 'fastrans')],
						['block_title' => esc_html__('Satisfied Clients', 'fastrans')],
						['block_title' => esc_html__('Delivered Packages', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Enter The icons', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options'  => get_fontawesome_icons(),
						],
						[
							'name' => 'counter_value',
							'label' => esc_html__('Counter Value', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'alphabet_letter',
							'label' => esc_html__('Alphabet Letter', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'fastrans')
						],
					],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'fanfact_style',
			[
				'label' => esc_html__( 'Fanfact Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'fnf_icon_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Icon Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_icon_clr',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-innerbox .ft-funfact-icon i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'fnf_number_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_number_clr',
			[
				'label'     => esc_html__( 'Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-innerbox .ft-funfact-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'fnf_number_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-innerbox .ft-funfact-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'fnf_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-innerbox .ft-funfact-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'fnf_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-innerbox .ft-funfact-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of funfact section
	============================================= -->
	<section id="ft-funfact" class="ft-funfact-section">
		<div class="container">
			<div class="ft-funfact-content">
				<div class="row">
					<?php foreach($settings['funfact'] as $key => $item): ?>
                    <div class="col-lg-3 col-md-6 col-sm-6">
						<div class="ft-funfact-innerbox text-center">
							<div class="ft-funfact-icon">
								<i class="fal <?php echo esc_attr(str_replace( "fa ",  "", $item['icons']));?>"></i>
							</div>
							<div class="ft-funfact-text headline pera-content">
								<h3><span class="counter"><?php echo esc_attr($item['counter_value']);?></span><?php echo esc_attr($item['alphabet_letter']);?></h3>
								<p><?php echo wp_kses($item['block_title'], true);?></p>
							</div>
						</div>
					</div>
                    <?php endforeach; ?>
				</div>
			</div>
		</div>
	</section>		
	<!-- End of funfact section
	============================================= -->
		
    <?php 
	
	}
}