<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use \Elementor\Group_Control_Background;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Feature extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'feature';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Feature', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'feature_section',
				[
					'label' => esc_html__( 'Feature Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'section_bg',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'We are Fastrans', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub title here', 'fastrans' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'We Are Global Courier Network', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your title here', 'fastrans'),
                'label_block' => true,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ftn-section-title h2 span::after',
			]
		);

        
		$this->end_controls_section();

        $this->start_controls_section(
            'feature_box_section',
            [
                'label' => __( 'Feature Box', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'middle_item',
			[
				'label' => esc_html__( 'Center?', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fastrans' ),
				'label_off' => esc_html__( 'Hide', 'fastrans' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $repeater->add_control(
            'feature_icon',
            [
                'label' => esc_html__( 'Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'feature_title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Fast Delivery', 'fastrans' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_info',
            [
                'label' => esc_html__( 'Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'We are very proud of our workforce and have worked hard to create a business that attracts those people.', 'fastrans' ),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Feature List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__( 'Fast Delivery', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'Secured Service', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'World Wide Shipping', 'fastrans' ),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'feature_section_style',
			[
				'label' => esc_html__( 'Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-section-title .sub-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_highlight_color',
			[
				'label'     => esc_html__( 'Title Highlight Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'feature_box_style',
            [
                'label' => __( 'Feature Box Style', 'fastrans' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'feature_padding',
			[
				'label' => esc_html__( 'Padding', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ftn-feature-inner-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'feature_shadow_h',
			[
				'label' => esc_html__( 'Box Shadow', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'feature_shadow',
			[
				'label' => esc_html__( 'Box Shadow', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
				'selectors' => [
					'{{SELECTOR}} .ftn-feature-inner-item' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
        $this->add_control(
			'feature_shadow_center_item_h',
			[
				'label' => esc_html__( 'Center Item Box Shadow', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'feature_shadow_center_item',
			[
				'label' => esc_html__( 'Center Item Box Shadow', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
				'selectors' => [
					'{{SELECTOR}} .ftn-feature-inner-item.middle-item' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
        $this->add_control(
            'f_bg_color',
            [
                'label'     => esc_html__( 'Background Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ftn-feature-inner-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ftn-feature-inner-item .ftn-featurei-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'f_title_color',
            [
                'label'     => esc_html__( 'Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ftn-feature-inner-item .ftn-feature-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'f_title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-feature-inner-item .ftn-feature-text h3',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'f_content_color',
            [
                'label'     => esc_html__( 'Content Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ftn-feature-inner-item .ftn-feature-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'f_content_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-feature-inner-item .ftn-feature-text p',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Feature Section -->
        <section id="ftn-feature" class="ftn-feature-section position-relative">
		<span class="ftn-feature-map position-absolute"><img src="<?php echo esc_url($settings['section_bg']['url']); ?>" alt="<?php echo esc_attr($settings['section_bg']['alt']);?>"></span>
		<div class="container">
			<div class="ftn-section-title headline  wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">

                <?php if(!empty($settings['sub_title'])):?>
				<span class="sub-title text-uppercase"><?php echo esc_html( $settings['sub_title']);?></span>
                <?php endif;?>

                <?php if(!empty($settings['title'])):?>
				<h2><?php echo $settings['title'];?></h2>
                <?php endif;?>
                
			</div>
			<div class="ftn-feature-content  wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
				<div class="row justify-content-center">
                    <?php
                        foreach ($settings['items'] as $item):
                    ?>
					<div class="col-lg-4 col-md-6 no-padding">
						<div class="ftn-feature-inner-item <?php if($item['middle_item'] == 'yes'){echo esc_attr('middle-item');}?>">
							<div class="ftn-featurei-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $item['feature_icon'], [ 'aria-hidden' => 'true' ] ); ?>
							</div>
							<div class="ftn-feature-text headline pera-content">

                                <?php if(!empty($item['feature_title'])):?>
                                <h3><?php echo $item['feature_title'];?></h3>
                                <?php endif;?>
                                
                                <?php if(!empty($item['feature_info'])):?>
								<p><?php echo $item['feature_info']; ?></p>
                                <?php endif;?>

							</div>
						</div>
					</div>

                    <?php endforeach; ?>
				</div>
			</div>
		</div>
	</section>
        <!-- End Feature Section -->

    <?php 
	
	}

}