<?php
	$options = fastrans_WSH()->option();
	$allowed_html = wp_kses_allowed_html( 'post' );
	
	
	// Header
	$header_type = get_post_meta( get_the_id(), 'header_type', true );
	$logo_header_v9 = $options->get( 'logo_header_v9' );
	$white_and_orange_logo_dimension = $options->get( 'logo_header_v9_dimension' );
	
	
	$logo_type = '';
	$logo_text = '';
	$logo_typography = ''; ?>

<header id="ftn-header" class="ftn-header-section">
    <div class="ftn-header-content-area position-relative">
        <div class="container">
            <div class="ftn-header-content-wrap d-flex justify-content-between">
                <div class="brand-logo">
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($logo_header_v9['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>"></a>
                </div>
                <div class="ftn-header-content">
                    <div class="header-top-cta ul-li">

                        <ul>
							<?php if($options->get('phone_v9')){ ?><li><i class="fas fa-phone-alt"></i> <?php echo wp_kses($options->get('phone_v9'), true); ?></li><?php } ?>
							<?php if($options->get('address_v9')){ ?><li><i class="fas fa-map-marker-alt"></i> <?php echo wp_kses($options->get('address_v9'), true); ?></li><?php } ?>
							<?php if($options->get('time_v9')){ ?><li><i class="fas fa-clock"></i> <?php echo wp_kses($options->get('time_v9'), true); ?></li><?php } ?>
                        </ul>
                    </div>
                    <div class="ftn-header-main-menu-cta-btn d-flex align-items-center">
                        <nav class="ftn-main-navigation clearfix ul-li">
                            <ul id="ftn-main-nav" class="nav navbar-nav clearfix">
								<?php
									if(true == $header_type){
										wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}else{
										wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}
								
								?>
                            </ul>
                        </nav>
						<?php if(!empty($options->get('btn_label_v9'))): ?>
                            <div class="header-cta-btn">
                                <a href="<?php echo esc_url($options->get('btn_label_v9_link')); ?>"><?php echo wp_kses($options->get('btn_label_v9'), true); ?></a>
                            </div>
						<?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="mobile_menu position-relative">
                <div class="mobile_menu_button open_mobile_menu">
                    <i class="fal fa-bars"></i>
                </div>
                <div class="mobile_menu_wrap">
                    <div class="mobile_menu_overlay open_mobile_menu"></div>
                    <div class="mobile_menu_content">
                        <div class="mobile_menu_close open_mobile_menu">
                            <i class="fal fa-times"></i>
                        </div>
                        <div class="m-brand-logo">
                            <a href="!#"><img src="assets/img/logo/logo4.png" alt=""></a>
                        </div>
                        <nav class="mobile-main-navigation  clearfix ul-li">
                            <ul id="m-main-nav" class="navbar-nav text-capitalize clearfix">
								<?php
									if(true == $header_type){
										wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}else{
										wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										));
									}
								
								?>
                            </ul>
                        </nav>
                    </div>
                </div>
                <!-- /Mobile-Menu -->
            </div>
        </div>
    </div>
</header>