<?php
	$options = fastrans_WSH()->option();
	$allowed_html = wp_kses_allowed_html('post');
	
	//Light Color Logo Settings
	$white_logo = $options->get('white_color_logo');
	$white_logo_dimension = $options->get('white_color_logo_dimension');
	
	//Light Color Logo Settings
	$white_and_orange_logo = $options->get( 'white_and_orange_color_logo' );
	$white_and_orange_logo_dimension = $options->get( 'white_and_orange_color_logo_dimension' );
	
	//Mobile Logo Settings
	$mobile_logo = $options->get('mobile_color_logo');
	$mobile_logo_dimension = $options->get('mobile_color_logo_dimension');
	
	// Header logo
	$header_type = get_post_meta(get_the_id(), 'header_type', true);
	$fs_page_logo = get_post_meta(get_the_id(), 'fs_page_logo', true);
	
	//Header Menu Type
	$header_type = get_post_meta(get_the_id(), 'header_type', true);
	$icons = $options->get('icons_social_share');
	$logo_type = '';
	$logo_text = '';
	$logo_typography = '';
	


?>
<header id="tl-thx-header" class="tl-thx-header-section">
    <div class="container">
        <div class="tl-thx-header-main-content d-flex align-items-center justify-content-between">
            <div class="tl-thx-brand-logo">
                <a href="<?php echo esc_url(home_url()) ?>">
                    <?php if (!empty($fs_page_logo) && !empty($fs_page_logo['url'])){ ?>
                        <img src="<?php echo esc_url($fs_page_logo['url']); ?>"
                             alt="<?php esc_attr_e('Logo', 'fastrans'); ?>">
                   <?php } elseif (!empty($white_and_orange_logo) && !empty($white_and_orange_logo['url'])) { ?>
                        <img src="<?php echo esc_url($white_and_orange_logo['url']); ?>"
                             alt="<?php esc_attr_e('Logo', 'fastrans'); ?>">
					<?php }else { ?>
                        <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo/logo-5.png'); ?>"
                             alt="<?php esc_attr_e('Logo', 'fastrans'); ?>">
					<?php } ?>
                </a>
            </div>
            <div class="tl-thx-header-main-menu d-flex align-items-center justify-content-between">
                <div class="tl-thx-header-main-menu-cta  d-flex align-items-center">
                    <nav class="tl-thx-main-navigation clearfix ul-li">
						<?php
							if (true == $header_type) {
								wp_nav_menu(array(
									'theme_location' => 'onepage_menu',
									'menu_class' => 'nav navbar-nav clearfix',
									'menu_id' => 'tl-thx-main-nav',
									'fallback_cb' => false,
									'container' => false,
									'depth' => '3',
									'walker' => new Bootstrap_walker()
								));
							} else {
								wp_nav_menu(array(
									'theme_location' => 'main_menu',
									'menu_class' => 'nav navbar-nav clearfix',
									'menu_id' => 'tl-thx-main-nav',
									'fallback_cb' => false,
									'container' => false,
									'depth' => '3',
									'walker' => new Bootstrap_walker()
								));
							}
						?>
                    </nav>
                    <div class="tl-thx-header-cta-btn navSidebar-button open_mobile_menu">
                        <button><i class="fas fa-bars"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- Sidebar sidebar Item -->
<div class="xs-sidebar-group info-group">
    <div class="xs-overlay xs-bg-black"></div>
    <div class="xs-sidebar-widget">
        <div class="sidebar-widget-container">
            <div class="widget-heading">
                <a href="#" class="close-side-widget">
                    X
                </a>
            </div>
            <div class="sidebar-textwidget">

                <!-- Sidebar Info Content -->
                <div class="sidebar-info-contents headline pera-content">
                    <div class="content-inner">
                        <div class="logo">
							<?php echo fastrans_logo($logo_type, $white_logo, $white_logo_dimension, $logo_text, $logo_typography); ?>
                        </div>
						<?php
							if (is_active_sidebar('sidebar-nav')) {
								dynamic_sidebar('sidebar-nav');
							}
						?>
                        <!-- Social Box -->
                        <div class="content-box">
                            <h5><?php esc_html_e('Get Our Socials:', 'fastrans'); ?></h5>
                            <ul class="social-box">
								<?php foreach ($icons as $h_icon) :
									$header_social_icons = json_decode(urldecode(fastrans_set($h_icon, 'data')));
									if (fastrans_set($header_social_icons, 'enable') == '') {
										continue;
									}
									$icon_class = explode('-', fastrans_set($header_social_icons, 'icon')); ?>
                                    <li><a target="_blank"
                                           href="<?php echo esc_url(fastrans_set($header_social_icons, 'url')); ?>"><i
                                                    class="fab <?php echo esc_attr(fastrans_set($header_social_icons, 'icon')); ?>"></i></a>
                                    </li>
								<?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="mobile_menu tl-thx-mobile position-relative">
    <div class="mobile_menu_wrap">
        <div class="mobile_menu_overlay open_mobile_menu"></div>
        <div class="mobile_menu_content">
            <div class="mobile_menu_close open_mobile_menu">
                <i class="fal fa-times"></i>
            </div>
            <div class="m-brand-logo">
				<?php echo fastrans_logo($logo_type, $white_logo, $white_logo_dimension, $logo_text, $logo_typography); ?>
            </div>
            <nav class="mobile-main-navigation  clearfix ul-li">
				<?php
					if (true == $header_type) {
						wp_nav_menu(array(
							'theme_location' => 'onepage_menu',
							'menu_class' => 'navbar-nav text-capitalize clearfix',
							'menu_id' => 'm-main-nav',
							'fallback_cb' => false,
							'container' => false,
							'depth' => '3',
							'walker' => new Bootstrap_walker()
						));
					} else {
						wp_nav_menu(array(
							'theme_location' => 'main_menu',
							'menu_class' => 'navbar-nav text-capitalize clearfix',
							'menu_id' => 'm-main-nav',
							'fallback_cb' => false,
							'container' => false,
							'depth' => '3',
							'walker' => new Bootstrap_walker()
						));
					}
				?>
            </nav>
        </div>
    </div>
    <!-- /Mobile-Menu -->
</div>
<!-- End of header section
	============================================= -->
