<?php
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Color Logo Settings
$white_logo = $options->get( 'white_color_logo' );
$white_logo_dimension = $options->get( 'white_color_logo_dimension' );

//Mobile Logo Settings
$mobile_logo = $options->get( 'mobile_color_logo' );
$mobile_logo_dimension = $options->get( 'mobile_color_logo_dimension' );

//Header Menu Type
$header_type = get_post_meta( get_the_id(), 'header_type', true );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<!-- Start of header section
	============================================= -->
	<header id="ft-header" class="ft-header-section header-style-one">
		<div class="ft-header-content-wrapper position-relative">
			<div class="container">
				<div class="ft-header-content position-relative">
					<div class="ft-brand-logo">
						<?php echo fastrans_logo( $logo_type, $white_logo, $white_logo_dimension, $logo_text, $logo_typography ); ?>
					</div>
					<div class="ft-header-menu-top-cta position-relative">
						<?php if($options->get('email_address_v2') || $options->get('address_v2')){ ?>
                        <div class="ft-header-top ul-li">
							<ul>
								<?php if($options->get('email_address_v2')){ ?><li><i class="fal fa-envelope"></i><?php echo wp_kses($options->get('email_address_v2'), true); ?></li><?php } ?>
								<?php if($options->get('address_v2')){ ?><li><i class="fal fa-map-marker-alt"></i><?php echo wp_kses($options->get('address_v2'), true); ?></li><?php } ?>
							</ul>
						</div>
                        <?php } ?>
                        <div class="ft-header-main-menu d-flex justify-content-end align-items-center">
							<nav class="ft-main-navigation clearfix ul-li">
								<ul id="ft-main-nav" class="nav navbar-nav clearfix">
								<?php 
								if(true == $header_type){
									wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
										'container_class'=>'navbar-collapse collapse navbar-right',
										'menu_class'=>'nav navbar-nav',
										'fallback_cb'=>false,
										'items_wrap' => '%3$s',
										'container'=>false,
										'depth'=>'3',
										'walker'=> new Bootstrap_walker()
									)); 
								}else{
									wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
										'container_class'=>'navbar-collapse collapse navbar-right',
										'menu_class'=>'nav navbar-nav',
										'fallback_cb'=>false,
										'items_wrap' => '%3$s',
										'container'=>false,
										'depth'=>'3',
										'walker'=> new Bootstrap_walker()
									)); 
								}
							?>
								</ul>
							</nav>
                            <?php if($options->get('show_button_v2')){ ?>
							<div class="ft-header-cta-btn">
								<a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($options->get('btn_link_v2')); ?>"><?php echo wp_kses($options->get('btn_title_v2'), true); ?></a>
							</div>
                            <?php } ?>
						</div>
					</div>
					<div class="mobile_menu position-relative">
						<div class="mobile_menu_button open_mobile_menu">
							<i class="fal fa-bars"></i>
						</div>
						<div class="mobile_menu_wrap">
							<div class="mobile_menu_overlay open_mobile_menu"></div>
							<div class="mobile_menu_content">
								<div class="mobile_menu_close open_mobile_menu">
									<i class="fal fa-times"></i>
								</div>
								<div class="m-brand-logo">
									<?php echo fastrans_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?>
								</div>
								<nav class="mobile-main-navigation  clearfix ul-li">
									<ul id="m-main-nav" class="navbar-nav text-capitalize clearfix">
									<?php 
									if(true == $header_type){
										wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										)); 
									}else{
										wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										)); 
									}
									?>
									</ul>
								</nav>
							</div>
						</div>
						<!-- /Mobile-Menu -->
					</div>
				</div>
			</div>
			<?php if($options->get('show_phone_no_v2')){ ?>
            <div class="ft-header-cta-info d-flex">
				<div class="ft-header-cta-icon d-flex justify-content-center align-items-center">
					<i class="flaticon-call"></i>
				</div>
				<div class="ft-header-cta-text headline pera-content">
					<p><?php esc_html_e('Get In Touch', 'fastrans'); ?></p>
					<h3><?php echo wp_kses($options->get('phone_no_v2'), true); ?></h3>
				</div>
			</div>
            <?php } ?>
		</div>
	</header>
	<!-- End of header section
	============================================= -->