<?php
/**
 * Footer Template  File
 *
 * @package FASTRANS
 * @author  Template Path
 * @version 1.0
 */

$options = fastrans_WSH()->option();

$bg_img3    = $options->get( 'footer_bg_img3' );
$bg_img3    = fastrans_set( $bg_img3, 'url', FASTRANS_URI . 'assets/images/bg/f-bg.png' );

$allowed_html = wp_kses_allowed_html( 'post' );
?>
	
    <!-- Start of Footer   section
	============================================= -->
	<footer id="ft-footer-2" class="ft-footer-section-2" <?php if($bg_img3){ ?>data-background="<?php echo esc_url($bg_img3);?>"<?php } ?>>
		
		<?php if( $options->get('show_newslatter_form_v3') ){ ?>
        <div class="ft-footer-newslatter position-relative">
			<div class="container">
				<div class="ft-footer-newslatter-content d-flex justify-content-between align-items-center flex-wrap">
					<div class="ft-footer-newslatter-text headline">
						<h2><?php echo wp_kses($options->get('newslatter_form_title'), true); ?></h2>	
					</div>
					<div class="ft-footer-newslatter-form position-relative">
						<?php echo do_shortcode($options->get('newslatter_form_url')); ?>
					</div>
				</div>
			</div>
		</div>
        <?php } ?>
        
        <?php if ( is_active_sidebar( 'footer-sidebar3' ) ) { ?>
		<div class="ft-footer-widget-wrapper-2">
			<div class="container">
				<div class="row">
					<?php dynamic_sidebar( 'footer-sidebar3' ); ?>
				</div>
			</div>
		</div>
        <?php } ?>
        
		<div class="ft-footer-copywrite-2 text-center">
			<span><?php echo wp_kses( $options->get( 'copyright_text3', 'Copyright @ 2021 Fastrans. All Rights Reserved.' ), true ); ?></span>
		</div>
        
	</footer>		
	<!-- End of FAQ why choose  section
	============================================= -->