<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'fastrans' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'fastrans' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'fastrans' ),
				'e' => esc_html__( 'Elementor', 'fastrans' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'fastrans' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'fastrans' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),

		//Header Settings
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'fastrans' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'fastrans' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style 1', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style 2', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
				'header_v3'  => array(
				    'alt' => esc_html__( 'Header Style 3', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header3.png',
			    ),
				'header_v4'  => array(
				    'alt' => esc_html__( 'Header Style 4', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header4.png',
			    ),
				'header_v5'  => array(
				    'alt' => esc_html__( 'Header Style 5', 'fastrans' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header5.png',
			    ),
                'header_v6' => array(
                    'alt' => 'Header Style 6',
                    'img' => get_template_directory_uri() . '/assets/images/redux/header/header6.png',
                ),
				'header_v7' => array(
                    'alt' => 'Header Style 7',
                    'img' => get_template_directory_uri() . '/assets/images/redux/header/header7.png',
                ),
				'header_v8' => array(
                    'alt' => 'Header Style 8',
                    'img' => get_template_directory_uri() . '/assets/images/redux/header/header8.png',
                ),
				'header_v9' => array(
                    'alt' => 'Header Style 9',
                    'img' => get_template_directory_uri() . '/assets/images/redux/header/header9.png',
                ),
				'header_v11' => array(
                    'alt' => 'Header Style 11',
                    'img' => get_template_directory_uri() . '/assets/images/redux/header/header11.png',
                ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v3',
	    ),

		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		array(
            'id' => 'show_topbar_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Topbar', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
			'id'      => 'address_v1',
			'type'    => 'text',
			'title'   => __( 'Address', 'fastrans' ),
			'required' => array( 'show_topbar_v1', '=', true ),
		),
		array(
			'id'      => 'address_v1_url',
			'type'    => 'text',
			'title'   => __( 'Address URL', 'fastrans' ),
			'required' => array( 'show_topbar_v1', '=', true ),
		),
		array(
			'id'      => 'working_days_v1',
			'type'    => 'text',
			'title'   => __( 'Working Days', 'fastrans' ),
			'required' => array( 'show_topbar_v1', '=', true ),
		),
		array(
			'id'      => 'working_days_v1_url',
			'type'    => 'text',
			'title'   => __( 'Working Days URL', 'fastrans' ),
			'required' => array( 'show_topbar_v1', '=', true ),
		),
		array(
			'id'      => 'phone_no_v1',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'fastrans' ),
			'required' => array( 'show_topbar_v1', '=', true ),
		),
		array(
            'id' => 'show_button_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Quote Button', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
			'id'      => 'btn_title_v1',
			'type'    => 'text',
			'title'   => __( 'Button Title', 'fastrans' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		array(
			'id'      => 'btn_link_v1',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'fastrans' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
			'id'      => 'email_address_v2',
			'type'    => 'text',
			'title'   => __( 'Email Address', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
			'id'      => 'address_v2',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
            'id' => 'show_button_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Order Now Button', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
			'id'      => 'btn_title_v2',
			'type'    => 'text',
			'title'   => __( 'Button Title', 'fastrans' ),
			'required' => array( 'show_button_v2', '=', true ),
		),
		array(
			'id'      => 'btn_link_v2',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'fastrans' ),
			'required' => array( 'show_button_v2', '=', true ),
		),
		array(
            'id' => 'show_phone_no_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Phone Number', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
			'id'      => 'phone_no_v2',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'fastrans' ),
			'required' => array( 'show_phone_no_v2', '=', true ),
		),
        /***********************************************************************
								Header Version 3 Start
		************************************************************************/
		array(
			'id'       => 'header_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Three Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		array(
            'id' => 'show_topbar_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Topbar', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
			'id'      => 'email_address_v3',
			'type'    => 'text',
			'title'   => __( 'Email Address', 'fastrans' ),
			'required' => array( 'show_topbar_v3', '=', true ),
		),
		array(
			'id'      => 'address_v3',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'fastrans' ),
			'required' => array( 'show_topbar_v3', '=', true ),
		),
		array(
            'id' => 'show_phone_no_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Phone Number', 'fastrans'),
            'default' => false,
            'required' => array( 'show_topbar_v3', '=', true),
        ),
		array(
			'id'      => 'phone_no_v3',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'fastrans' ),
			'required' => array( 'show_phone_no_v3', '=', true ),
		),
		array(
            'id' => 'show_button_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Order Now Button', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
			'id'      => 'btn_title_v3',
			'type'    => 'text',
			'title'   => __( 'Button Title', 'fastrans' ),
			'required' => array( 'show_button_v3', '=', true ),
		),
		array(
			'id'      => 'btn_link_v3',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'fastrans' ),
			'required' => array( 'show_button_v3', '=', true ),
		),
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),

		/***********************************************************************
								Header Version 5 Start
		************************************************************************/
		array(
			'id'       => 'header_v5_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Five Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'btn_label_v5',
			'type'    => 'text',
			'title'   => __( 'Button Label 5', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'btn_label_v5_link',
			'type'    => 'text',
			'title'   => __( 'Button Link 5', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'phone_address_v2',
			'type'    => 'text',
			'title'   => __( 'Phone', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'address_v5',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'time_v5',
			'type'    => 'textarea',
			'title'   => __( 'Time', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id'      => 'get_our_social_text',
			'type'    => 'text',
			'title'   => __( 'Get Our Social Text', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
			'default' => __('Get Our Socials:', 'fastrans'),
		),
		array(
			'id' => 'header_v5_top_header_BG_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Header BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_header_secondary_BG_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Header Secondary BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_phone_content_BG_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Phone Content BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_address_BG_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Address BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_time_BG_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Time BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_content_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Content Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
			'id' => 'header_v5_top_social_icon_hover_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header V5 Top Social Icon Hover Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
        /***********************************************************************
        Header Version 6 Start
         ************************************************************************/
        array(
            'id'       => 'header_v6_settings_section_start',
            'type'     => 'section',
            'indent'      => true,
            'title'    => esc_html__( 'Header Style Six Settings', 'fastrans' ),
            'required' => array( 'header_style_settings', '=', 'header_v6' ),
        ),
        array(
            'id' => 'show_topbar_v6',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Topbar', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v6' ),
        ),
        array(
            'id'      => 'address_v6',
            'type'    => 'textarea',
            'title'   => __( 'Address', 'fastrans' ),
            'required' => array( 'show_topbar_v6', '=', true ),
        ),
        array(
            'id'      => 'email_address_v6',
            'type'    => 'text',
            'title'   => __( 'Email Address', 'fastrans' ),
            'required' => array( 'show_topbar_v6', '=', true ),
        ),
        array(
            'id'      => 'email_address_url_v6',
            'type'    => 'text',
            'title'   => __( 'Email Address Url', 'fastrans' ),
            'required' => array( 'show_topbar_v6', '=', true ),
        ),
        array(
            'id' => 'show_language_v6',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Language', 'fastrans'),
            'default' => false,
            'required' => array( 'show_topbar_v6', '=', true),
        ),
        array(
            'id'      => 'language_image_v6',
            'type'    => 'media',
            'title'   => __( 'Language Image', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id'      => 'language_name_v6',
            'type'    => 'text',
            'title'   => __( 'Language Name', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id'      => 'language_name_v6_1',
            'type'    => 'text',
            'title'   => __( 'Language Name 1', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id'      => 'language_name_v6_2',
            'type'    => 'text',
            'title'   => __( 'Language Name 2', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id'      => 'language_name_v6_3',
            'type'    => 'text',
            'title'   => __( 'Language Name 3', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id'      => 'language_name_v6_4',
            'type'    => 'text',
            'title'   => __( 'Language Name 4', 'fastrans' ),
            'required' => array( 'show_language_v6', '=', true ),
        ),
        array(
            'id' => 'show_button_v6',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Button', 'fastrans'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v6' ),
        ),
        array(
            'id'      => 'btn_title_v6',
            'type'    => 'text',
            'title'   => __( 'Button Title', 'fastrans' ),
            'required' => array( 'show_button_v6', '=', true ),
        ),
        array(
            'id'      => 'btn_link_v6',
            'type'    => 'text',
            'title'   => __( 'Button Link', 'fastrans' ),
            'required' => array( 'show_button_v6', '=', true ),
        ),
		
		/***********************************************************************
								Header Version 9 Start
		************************************************************************/
		array(
			'id'       => 'header_v9_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Nine Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		array(
			'id'      => 'btn_label_v9',
			'type'    => 'text',
			'title'   => __( 'Button Label', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		array(
			'id'      => 'btn_label_v9_link',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),

		array(
			'id'      => 'phone_v9',
			'type'    => 'textarea',
			'title'   => __( 'Phone', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),

		array(
			'id'      => 'address_v9',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		array(
			'id'      => 'time_v9',
			'type'    => 'textarea',
			'title'   => __( 'Time', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		array(
			'id' => 'header_9_primary_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 9 Primary Color', 'fastrans'),
			'default'  => '#d97500',
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		array(
			'id' => 'header_9_button_hover_bg',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 9 Button Hover BG', 'fastrans'),
			'default'  => '#ba6502',
			'required' => array( 'header_style_settings', '=', 'header_v9' ),
		),
		/***********************************************************************
		Header Version 11 Start
		 ************************************************************************/
		array(
			'id'       => 'header_v11_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Eleven Settings', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id'      => 'phone_v11',
			'type'    => 'text',
			'title'   => __( 'Phone', 'fastrans' ),
			'default' => __('Need any help? Call Us: (210) 123-451' , 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		
		array(
			'id'      => 'address_v11',
			'type'    => 'text',
			'title'   => __( 'Address', 'fastrans' ),
			'default' => __('380 St Kilda Road, Australia' , 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id'      => 'time_v11',
			'type'    => 'text',
			'title'   => __( 'Time', 'fastrans' ),
			'default' => __('Sat - Thursday (9am - 10 pm)' , 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id'      => 'btn_label_v11',
			'type'    => 'text',
			'title'   => __( 'Button Label', 'fastrans' ),
			'default' => __('Free Quote' , 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id'      => 'btn_label_v11_link',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'fastrans' ),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_top_bg_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Top BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_top_content_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Top Content Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_logo_bg_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Logo BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_nav_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Nav Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_sub_menu_hover_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Sub Menu Hover Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_button_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Button Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_button_bg_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Button BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		array(
			'id' => 'header_11_button_hover_bg_color',
			'type' => 'color',
			'transparent'=> false,
			'title' => esc_html__('Header 11 Button Hover BG Color', 'fastrans'),
			'required' => array( 'header_style_settings', '=', 'header_v11' ),
		),
		
	),
);
